/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXProducer;
import kd.bos.mq.dlx.DLXRabbitDLXProducer;
import kd.bos.mq.dlx.DLXRocketDLXProducer;
import kd.bos.mq.init.MQInit;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class DLXProducerFactory {
    private static final Map<String, DLXProducer> publisherPool = new ConcurrentHashMap<String, DLXProducer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DLXProducer getOrCreate(String region, String queueName, String mqType) {
        String key = QueueManager.getRealQueueName(mqType + region, queueName);
        DLXProducer producer = publisherPool.get(key);
        if (producer != null) return producer;
        Class<DLXProducerFactory> clazz = DLXProducerFactory.class;
        synchronized (DLXProducerFactory.class) {
            producer = publisherPool.get(key);
            if (producer != null) return producer;
            producer = DLXProducerFactory.createSimpleProducer(region, queueName, mqType);
            publisherPool.put(key, producer);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return producer;
        }
    }

    private static DLXProducer createSimpleProducer(String region, String queueName, String mqType) {
        if (region == null) {
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"region cannot been null "});
        }
        MQInit.waitForMQFinishInit(region);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueName);
        if (def == null) {
            throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        if ("rabbitmq".equals(mqType)) {
            return DLXProducerFactory.createRabbitProducer(region, queueName);
        }
        return DLXProducerFactory.createRocketProducer(region, queueName);
    }

    private static DLXProducer createRabbitProducer(String region, String queueName) {
        try {
            return new DLXRabbitDLXProducer(region, queueName);
        }
        catch (Error | Exception t) {
            ExceptionLogger.log("RabbitFactory.createSimplePublisher error", t);
            throw new KDException(t, BosErrorCode.rabbitmqException, new Object[]{"error when create publisher"});
        }
    }

    private static DLXProducer createRocketProducer(String region, String queueName) {
        String dlxServerKey = DLXConfig.getDLXServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)dlxServerKey);
        try {
            DefaultMQProducer producer = new DefaultMQProducer(ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueName + "-dlx"), ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword()));
            producer.setNamesrvAddr(rocketInfo.getHost());
            producer.start();
            return new DLXRocketDLXProducer(producer, queueName, rocketInfo.getVhost());
        }
        catch (MQClientException e) {
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"ProducerFactory.getProducer can't get producer" + e.getMessage()});
        }
        catch (Exception t) {
            ExceptionLogger.log("RocketFactory.createSimplePublisher error", t);
            throw new KDException((Throwable)t, BosErrorCode.rocketmqException, new Object[]{"error when create publisher,region:" + region + ",queueName:" + queueName});
        }
    }
}

