/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.dlx.DLXProducer;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueManager;
import kd.bos.rabbitmq.RabbitmqFactory;

public class DLXRabbitDLXProducer
implements DLXProducer {
    private String queueName;
    private String region;
    private AtomicBoolean declared = new AtomicBoolean();

    protected DLXRabbitDLXProducer(String region, String queueName) {
        this.region = region;
        this.queueName = queueName;
    }

    @Override
    public void send(Message message) {
        byte[] bytes = MessageSerde.get().encode(message);
        try (Channel channel = DLXRabbitDLXProducer.getChannel(this.region);){
            if (this.declared.compareAndSet(false, true)) {
                this.dlxQueueDeclare(channel);
            }
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
            AMQP.BasicProperties properties = builder.build();
            builder.deliveryMode(Integer.valueOf(2));
            channel.basicPublish("", this.queueName, properties, bytes);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"send message error"});
        }
    }

    public static Channel getChannel(String region) throws IOException {
        Connection con = RabbitmqFactory.getConnectionByRegion((String)region);
        return con.createChannel();
    }

    private void dlxQueueDeclare(Channel channel) {
        HashMap<String, Integer> args = new HashMap<String, Integer>(8);
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName("", this.queueName);
        boolean duration = queueDef.isDuration();
        try {
            int maxQueueLength = queueDef.getMaxQueueLength();
            if (maxQueueLength <= 0 || maxQueueLength > 1000000) {
                maxQueueLength = 1000000;
            }
            args.put("x-max-length", maxQueueLength);
            channel.queueDeclare(this.queueName, duration, false, false, args);
        }
        catch (Exception e) {
            ShutdownSignalException sse;
            if (e.getCause() != null && e.getCause() instanceof ShutdownSignalException && (sse = (ShutdownSignalException)e.getCause()) != null && sse.getMessage() != null && sse.getMessage().indexOf("inequivalent arg 'x-max-length'") > 0) {
                try {
                    if (sse.getMessage().indexOf("but current is none") > 0) {
                        channel.queueDelete(this.queueName);
                        channel.queueDeclare(this.queueName, duration, false, false, args);
                    }
                }
                catch (Exception e1) {
                    ExceptionLogger.log("queueDeclare", e1);
                }
                return;
            }
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[0]);
        }
    }
}

