/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMesPubFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.threads.ThreadPools;

public class DLXService {
    private static final Timer messageScan = new Timer("mq-dlx-messageScanTask");
    private static AtomicBoolean isStarted = new AtomicBoolean();

    public static void start() {
        final Elector elector = ElectFactory.getElector((String)"dlx-message");
        elector.registerListener(new ElectorListener(){

            public void notifyMaster() {
                if (elector.isMaster() && isStarted.compareAndSet(false, true)) {
                    messageScan.scheduleAtFixedRate((TimerTask)new ScanTask(), 500000L, 300000L);
                }
            }

            public void notifyLostMaster() {
                if (isStarted.compareAndSet(true, false)) {
                    messageScan.cancel();
                }
            }
        });
        elector.start();
    }

    private static class ScanTask
    extends TimerTask {
        private static final String SCAN_SQL = "select top 10 fid,fmessage,fstatus,fregion,fqueue from t_dlx_message where fstatus = 0 and fcount < " + DLXConfig.SEND_ERROR_COUNT;

        private ScanTask() {
        }

        @Override
        public void run() {
            ThreadPools.executeOnce((String)"message_scan", () -> {
                List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
                accounts.forEach(account -> {
                    RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
                    try (AutoCloseable ignored = rc.setupThreadRequestContext();){
                        ArrayList messageList = new ArrayList(10);
                        DB.query((DBRoute)DBRoute.basedata, (String)SCAN_SQL, resultSet -> {
                            while (resultSet.next()) {
                                JSONObject json = new JSONObject();
                                json.put("region", (Object)resultSet.getString("fregion"));
                                json.put("queue", (Object)resultSet.getString("fqueue"));
                                json.put("fid", (Object)resultSet.getInt("fid"));
                                json.put("message", (Object)resultSet.getBytes("fmessage"));
                                messageList.add(json);
                            }
                            return null;
                        });
                        for (JSONObject jsonObject : messageList) {
                            try {
                                byte[] bytes = jsonObject.getBytes("message");
                                Message message = MessageSerde.get().decode(bytes);
                                String region = jsonObject.getString("region");
                                String queue = jsonObject.getString("queue");
                                DLXMesPubFactory.getDLXMessagePublisher().sendMessage(region, queue, message, "", null);
                            }
                            catch (Exception e) {}
                        }
                    }
                    catch (Exception e) {
                        ExceptionLogger.log("message scan task error", e);
                    }
                });
            });
        }
    }
}

