/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.dlx;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMessagePublisher;
import kd.bos.mq.dlx.DLXProducer;
import kd.bos.mq.dlx.DLXProducerFactory;
import kd.bos.mq.dlx.MessageRecord;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;

public class DefaultPublisher
implements DLXMessagePublisher {
    @Override
    public void sendMessage(String region, String queueName, Message message, String messageId, MessageAcker messageAcker) {
        block29: {
            int errorCount;
            long innerId = message.getInnerId();
            byte[] bytes = MessageSerde.get().encode(message);
            try {
                errorCount = MessageRecord.insert(innerId, bytes, region, queueName);
                this.ackMessage(messageAcker, messageId, 1);
            }
            catch (Exception e) {
                this.ackMessage(messageAcker, messageId, 2);
                return;
            }
            if (errorCount < DLXConfig.SEND_ERROR_COUNT) {
                try (DLock lock = DLock.create((String)String.valueOf(innerId), (String)"message migrate");){
                    if (!lock.tryLock(3000L)) break block29;
                    try (TXHandle ignored = TX.requiresNew();){
                        DLXProducer producer = DLXProducerFactory.getOrCreate(region, queueName, DLXConfig.getMQType(region));
                        MessageRecord.update(1, innerId);
                        producer.send(message);
                    }
                    catch (Exception e) {
                        ExceptionLogger.warn("migrate message fail,the message has been saved in the database", e);
                    }
                }
            }
        }
    }

    private void ackMessage(MessageAcker rabbitAck, String messageId, int type) {
        if (rabbitAck != null) {
            if (type == 1) {
                rabbitAck.ack(messageId);
            } else if (type == 2) {
                rabbitAck.deny(messageId);
            } else {
                rabbitAck.discard(messageId);
            }
        }
    }
}

