/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FailoverConfig {
    private static final Log log = LogFactory.getLog(FailoverConfig.class);
    public static final boolean MQ_FAILOVER_ENABLE = Boolean.getBoolean("mq.failover.enable");
    public static final String MQ_FAILOVER_SERVER = "mq.failover.server";
    public static final String MQ_FAILOVER_STATUS = "mq.failover.status";
    private static Map<String, String> mqTypeMap = new ConcurrentHashMap<String, String>();

    public static String getMQType(String region) {
        String type = mqTypeMap.get(region);
        if (type != null) {
            return type;
        }
        String serverKey = "mq.failover.server." + region;
        String server = System.getProperty(serverKey);
        try {
            if (server != null) {
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "type can't be empty.");
            } else {
                type = mqTypeMap.get(MQ_FAILOVER_SERVER);
                if (type != null) {
                    return type;
                }
                server = System.getProperty(MQ_FAILOVER_SERVER);
                if (server == null) {
                    throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"mq server not config for " + server});
                }
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "FailoverConfig.getMQType() type can't be empty.");
                region = MQ_FAILOVER_SERVER;
            }
        }
        catch (IOException e) {
            log.error("get mq type exception", (Throwable)e);
        }
        mqTypeMap.put(region, type);
        return type != null ? type.trim() : null;
    }

    public static String getFailoverServerKey(String region) {
        String serverKey = "mq.failover.server." + region;
        String server = System.getProperty(serverKey);
        if (server != null) {
            return serverKey;
        }
        return MQ_FAILOVER_SERVER;
    }
}

