/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import kd.bos.dlock.DLock;
import kd.bos.extension.ExtensionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.failover.FailoverBroadcastUtil;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.failover.FailoverMoveTask;
import kd.bos.mq.failover.FailoverQueueManager;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.QueueManager;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.CollectionUtils;

public class FailoverMoveTaskFactory {
    private static final Log LOGGER = LogFactory.getLog(FailoverMoveTaskFactory.class);
    private static final ExtensionFactory<FailoverMoveTask> moveTaskExtensionFactory = ExtensionFactory.getExtensionFacotry(FailoverMoveTask.class);
    private static final BlockingQueue<PairMoveTask> taskQueue = new ArrayBlockingQueue<PairMoveTask>(2000);
    private static final AtomicBoolean isMoveTimerInit = new AtomicBoolean(false);

    public static void registerTask(String region, String queueRealName) {
        if (region.equals("demo")) {
            return;
        }
        PairMoveTask moveTask = new PairMoveTask(region, queueRealName);
        try {
            taskQueue.put(moveTask);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (isMoveTimerInit.compareAndSet(false, true)) {
            Timer timer = new Timer("FailoverMoveThread");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    FailoverMoveTaskFactory.doExecuteMoveTask();
                }
            }, 30000L);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void doExecuteMoveTask() {
        block5: while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((pairMoveTask = FailoverMoveTaskFactory.taskQueue.poll(Integer.getInteger("mq.failover.movethread.timeout", 300).intValue(), TimeUnit.SECONDS)) == null) {
                        FailoverMoveTaskFactory.LOGGER.info("All failover task execute success,stop FailoverMoveThread");
                        break block5;
                    }
                    if (FailoverQueueManager.isMoveStatusSuccess(pairMoveTask.queueRealName)) {
                        return;
                    }
                    dLock = DLock.create((String)("mq_failover_" + pairMoveTask.queueRealName + "_" + System.getProperty("mq.debug.queue.tag", "")));
                    if (!dLock.tryLock()) {
                        return;
                    }
                    try {
                        ThreadLifeCycleManager.start();
                        pairMoveTask.doMove();
                    }
                    finally {
                        dLock.unlock();
                        ThreadLifeCycleManager.end();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                FailoverMoveTaskFactory.LOGGER.error("doExecuteMoveTaskError", (Throwable)e);
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }

    private static class PairMoveTask {
        String region;
        String queueRealName;
        FailoverMoveTask originMoveTask;
        FailoverMoveTask failoverMoveTask;

        public PairMoveTask(String region, String queueRealName) {
            this.region = region;
            this.queueRealName = queueRealName;
            this.originMoveTask = (FailoverMoveTask)moveTaskExtensionFactory.getExtension(QueueManager.getMQType(region), false);
            this.originMoveTask.init(region, queueRealName);
            this.failoverMoveTask = (FailoverMoveTask)moveTaskExtensionFactory.getExtension(FailoverConfig.getMQType(region), false);
            this.failoverMoveTask.init(region, queueRealName);
        }

        public void doMove() {
            List<Message> moveMessageList;
            FailoverQueueManager.markMoveRunning(this.queueRealName);
            while (!CollectionUtils.isEmpty(moveMessageList = this.failoverMoveTask.getBatchMessageList())) {
                this.originMoveTask.move(moveMessageList);
                this.failoverMoveTask.afterMove();
            }
            FailoverQueueManager.markMoveSuccess(this.queueRealName);
            FailoverBroadcastUtil.markMoveSuccess(this.queueRealName);
            LockSupport.parkNanos(10000000L);
            moveMessageList = this.failoverMoveTask.getBatchMessageList();
            if (CollectionUtils.isNotEmpty(moveMessageList)) {
                this.originMoveTask.move(moveMessageList);
                this.failoverMoveTask.afterMove();
            }
            this.originMoveTask.recycleResource();
            this.failoverMoveTask.recycleResource();
        }

        public String toString() {
            return "PairMoveTask{region='" + this.region + '\'' + ", queueRealName='" + this.queueRealName + '\'' + '}';
        }
    }
}

