/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover.pigeon;

import java.util.List;
import java.util.ServiceLoader;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.failover.FailoverMessageCount;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;

public class PigeonFailoverMessageCount
implements FailoverMessageCount {
    @Override
    public int count(String region, String queueRealName) {
        if (RequestContext.get() == null) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"RequestContext must not be null!"});
        }
        RequestContext oldCtx = RequestContext.get();
        int totalCount = 0;
        List allAccountList = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account tempAccount : allAccountList) {
            PigeonRequestContextUtil.createDbRequestContext((String)tempAccount.getTenantId(), (String)tempAccount.getAccountId());
            for (IStoreDbConfig tempStoreDbConfig : ServiceLoader.load(IStoreDbConfig.class)) {
                int size = QueueMessageEntityHelper.count((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)tempStoreDbConfig, (String)queueRealName, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()});
                totalCount += size;
            }
        }
        if (oldCtx == null) {
            RequestContext.set(null);
        } else {
            PigeonRequestContextUtil.set((RequestContext)oldCtx);
        }
        return totalCount;
    }
}

