/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover.pigeon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.failover.FailoverMoveTask;
import kd.bos.mq.failover.FailoverPublisherWrapper;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.PigeonRequestContextUtil;
import kd.bos.util.CollectionUtils;

public class PigeonFailoverMoveTask
implements FailoverMoveTask {
    private static final Log LOGGER = LogFactory.getLog(PigeonFailoverMoveTask.class);
    private String region;
    private String queueRealName;
    private MessagePublisher originPublisher;
    private final AtomicBoolean isDeleteSuccessMessage = new AtomicBoolean(false);
    private Map<String, List<EntityWrapper>> accountId2entityWrapperListMap;

    @Override
    public void init(String region, String queueRealName) {
        this.region = region;
        this.queueRealName = queueRealName;
        FailoverPublisherWrapper failoverPublisherWrapper = (FailoverPublisherWrapper)MQFactory.get().$createPublisherWithRealQueueName(region, queueRealName);
        this.originPublisher = failoverPublisherWrapper.getOriginPublisher();
    }

    @Override
    public List<Message> getBatchMessageList() {
        RequestContext oldCtx = RequestContext.get();
        this.deleteFinishedMessage();
        ArrayList<Message> allMessageList = new ArrayList<Message>(1000);
        List allAccountList = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account tempAccount : allAccountList) {
            PigeonRequestContextUtil.createDbRequestContext((String)tempAccount.getTenantId(), (String)tempAccount.getAccountId());
            for (IStoreDbConfig tempStoreDbConfig : ServiceLoader.load(IStoreDbConfig.class)) {
                List queueMessageEntityList = QueueMessageEntityHelper.queryListForMsgdata((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)tempStoreDbConfig, (int)100, (String[])new String[]{MessageStatus.READY.getDesc(), MessageStatus.RETRY.getDesc()}, (String)this.queueRealName);
                if (!CollectionUtils.isNotEmpty((Collection)queueMessageEntityList)) continue;
                if (this.accountId2entityWrapperListMap == null) {
                    this.accountId2entityWrapperListMap = new HashMap<String, List<EntityWrapper>>(queueMessageEntityList.size());
                }
                ArrayList<Long> idList = new ArrayList<Long>(queueMessageEntityList.size());
                for (QueueMessageEntity tempMessageEntity : queueMessageEntityList) {
                    try {
                        Message message = PigeonFailoverMoveTask.toMessage(tempMessageEntity.getMsgData());
                        allMessageList.add(message);
                        idList.add(tempMessageEntity.getId());
                    }
                    catch (Exception e) {
                        LOGGER.error("QueueMessageEntity toMessage error,accountId:{},tableName:{},id:{},queueRealName:{}", new Object[]{tempAccount.getAccountId(), tempStoreDbConfig.getQueueMessageTable(), tempMessageEntity.getId(), this.queueRealName, e});
                    }
                }
                List wrapperList = this.accountId2entityWrapperListMap.computeIfAbsent(tempAccount.getAccountId(), key -> new ArrayList());
                wrapperList.add(new EntityWrapper(tempStoreDbConfig, idList));
            }
            LOGGER.info("getBatchMessageList success,tenantId:{},accountId:{}", (Object)tempAccount.getTenantId(), (Object)tempAccount.getAccountId());
        }
        if (oldCtx == null) {
            RequestContext.set(null);
        } else {
            PigeonRequestContextUtil.set((RequestContext)oldCtx);
        }
        return allMessageList;
    }

    private void deleteFinishedMessage() {
        if (this.isDeleteSuccessMessage.compareAndSet(false, true)) {
            RequestContext oldCtx = RequestContext.get();
            List allAccountList = AccountUtils.getAllAccountsOfCurrentEnv();
            for (Account tempAccount : allAccountList) {
                PigeonRequestContextUtil.createDbRequestContext((String)tempAccount.getTenantId(), (String)tempAccount.getAccountId());
                for (IStoreDbConfig tempStoreDbConfig : ServiceLoader.load(IStoreDbConfig.class)) {
                    int deleteSize = QueueMessageEntityHelper.deleteList((String)PigeonmqFactory.getVhost(), (IStoreDbConfig)tempStoreDbConfig, (String)this.queueRealName, null, (String[])new String[]{MessageStatus.SUCCESS.getDesc(), MessageStatus.DISCARD.getDesc(), MessageStatus.FAILED.getDesc()});
                    if (deleteSize <= 0) continue;
                    LOGGER.info("deleteFinishedMessageSuccess,queueRealName:{},deleteSize:{}", (Object)this.queueRealName, (Object)deleteSize);
                }
            }
            if (oldCtx == null) {
                RequestContext.set(null);
            } else {
                PigeonRequestContextUtil.set((RequestContext)oldCtx);
            }
        }
    }

    @Override
    public void move(List<Message> messageList) {
        RequestContext oldCtx = RequestContext.get();
        for (Message tempMessage : messageList) {
            PigeonRequestContextUtil.set((RequestContext)tempMessage.getRequestContext());
            byte[] bytes = MessageSerde.get().encode(tempMessage);
            this.originPublisher.$$publishConfirm(bytes);
        }
        if (oldCtx == null) {
            RequestContext.set(null);
        } else {
            PigeonRequestContextUtil.set((RequestContext)oldCtx);
        }
    }

    @Override
    public void afterMove() {
        if (this.accountId2entityWrapperListMap != null) {
            RequestContext oldCtx = RequestContext.get();
            for (Map.Entry<String, List<EntityWrapper>> entry : this.accountId2entityWrapperListMap.entrySet()) {
                String accountId = entry.getKey();
                Account tempAccount = AccountUtils.getAccountById((String)accountId);
                PigeonRequestContextUtil.createDbRequestContext((String)tempAccount.getTenantId(), (String)tempAccount.getAccountId());
                List<EntityWrapper> entityWrapperList = entry.getValue();
                for (EntityWrapper tempWrapper : entityWrapperList) {
                    QueueMessageEntityHelper.updateList((IStoreDbConfig)tempWrapper.tempStoreDbConfig, (List)tempWrapper.idList, (String)MessageStatus.SUCCESS.getDesc(), null, null);
                }
            }
            if (oldCtx == null) {
                RequestContext.set(null);
            } else {
                PigeonRequestContextUtil.set((RequestContext)oldCtx);
            }
        }
        this.accountId2entityWrapperListMap = null;
    }

    private static Message toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    @Override
    public void recycleResource() {
    }

    private static class EntityWrapper {
        private IStoreDbConfig tempStoreDbConfig;
        private List<Long> idList;

        public EntityWrapper(IStoreDbConfig tempStoreDbConfig, List<Long> idList) {
            this.tempStoreDbConfig = tempStoreDbConfig;
            this.idList = idList;
        }
    }
}

