/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.failover.rabbit;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.failover.FailoverMessageCount;
import kd.bos.rabbitmq.RabbitmqFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class RabbitFailoverMessageCount
implements FailoverMessageCount {
    private static final Log LOGGER = LogFactory.getLog(RabbitFailoverMessageCount.class);
    private static final ConcurrentHashMap<String, RabbitInfo> region2rabbitinfoMap = new ConcurrentHashMap();

    @Override
    public int count(String region, String queueRealName) {
        RabbitInfo rabbitInfo = region2rabbitinfoMap.get(region);
        if (rabbitInfo == null) {
            String serverKey = RabbitmqFactory.getRegionServerKey((String)region);
            rabbitInfo = RabbitFailoverMessageCount.getRabbitInfo(serverKey);
            region2rabbitinfoMap.putIfAbsent(region, rabbitInfo);
        }
        return this.queueMessageCount(rabbitInfo, queueRealName);
    }

    private int queueMessageCount(RabbitInfo rabbitInfo, String queueRealName) {
        String api = "/api/queues/" + rabbitInfo.vhost + "/" + queueRealName;
        try {
            String result = this.getRestfulResult(rabbitInfo.host, rabbitInfo.webport, api, rabbitInfo.username, rabbitInfo.password);
            JSONObject resultJSONObj = JSONObject.parseObject((String)result);
            return resultJSONObj.getInteger("messages");
        }
        catch (Exception e) {
            LOGGER.error("queueMessageCount error,RabbitInfo:{},queueRealName:{}", new Object[]{rabbitInfo, queueRealName, e});
            return -1;
        }
    }

    private String getRestfulResult(String hostip, int port, String api, String u, String p) throws IOException {
        HttpHost host = new HttpHost(hostip, port);
        HttpGet httpGet = new HttpGet(api);
        String decode = Encrypters.decode((String)p);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(hostip, port), (Credentials)new UsernamePasswordCredentials(u, decode));
        CloseableHttpClient client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        HttpResponse response = client.execute(host, (HttpRequest)httpGet);
        HttpEntity entity = response.getEntity();
        return EntityUtils.toString((HttpEntity)entity);
    }

    private static RabbitInfo getRabbitInfo(String serverKey) {
        RabbitInfo rabbitInfo = new RabbitInfo();
        Properties prop = new Properties();
        StringReader reader = new StringReader(System.getProperty(serverKey));
        try {
            String str;
            prop.load(reader);
            rabbitInfo.host = str = Objects.requireNonNull(prop.getProperty("host"), "host can't be empty.");
            String port = prop.getProperty("webport");
            if (port == null) {
                port = "1" + prop.getProperty("port");
            }
            rabbitInfo.webport = Integer.parseInt(port);
            rabbitInfo.username = str = Objects.requireNonNull(prop.getProperty("user"), "user can't be empty.");
            str = prop.getProperty("password");
            rabbitInfo.password = str = Encrypters.decode((String)str);
            rabbitInfo.vhost = str = Objects.requireNonNull(prop.getProperty("vhost"), "vhost can't be empty.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rabbitInfo;
    }

    private static class RabbitInfo {
        String host;
        int webport;
        String username;
        String password;
        String vhost;

        private RabbitInfo() {
        }

        public String toString() {
            return "RabbitInfo{host='" + this.host + '\'' + ", webport=" + this.webport + ", vhost='" + this.vhost + '\'' + '}';
        }
    }
}

