/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kd.bos.instance.MainGroupChangeListener;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.MQGrayManager;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.threads.ThreadPools;

public class MQAppGroupListener
implements MainGroupChangeListener {
    public void productionToEliminateNode(String appId, String appGroup) {
        ThreadPools.executeOnce((String)"productionToEliminateNode", () -> {
            boolean isAccrossNode;
            boolean bl = isAccrossNode = !ConsumerSupport.isNeedDeploy(appId);
            if (isAccrossNode) {
                ConsumerSupport.setNeedWaitPublishForAccrossNode(appId);
                return;
            }
            PublisherSupport.$$disablePublishMessage(appId);
            Map<String, Object> consumers = QueueManager.getConsumers();
            ArrayList<Object> noFinished = new ArrayList<Object>(consumers.values());
            List<Consumer> needStopConsumers = this.waitForConsumeFinish(noFinished, appId);
            for (Consumer needStopConsumer : needStopConsumers) {
                needStopConsumer.$$stop();
            }
            MQGrayManager.releaseResource();
        });
    }

    public void grayToProductionNode(String appId, String appGroup) {
        ThreadPools.executeOnce((String)"grayToProductionNode", () -> {
            MQGrayManager mqGrayManager;
            String region;
            ConcurrentHashMap<String, Consumer> consumersWithAppGroup = new ConcurrentHashMap<String, Consumer>(32);
            Map<String, String> queueNameMap = QueueManager.getQueueNameMap();
            Map<String, Object> consumers = QueueManager.getConsumers();
            ArrayList<Object> allConsumer = new ArrayList<Object>(consumers.values());
            Map<String, String> queueAppMap = QueueManager.getQueueAppMap();
            int times = 0;
            while (!ConsumerSupport.isOldStandrandConsumerFinished(appId, appGroup)) {
                boolean hasConsumer = false;
                int size = allConsumer.size();
                for (int i = size - 1; i >= 0; --i) {
                    Object value = allConsumer.get(i);
                    Consumer consumer = (Consumer)value;
                    String region2 = consumer.getRegion();
                    String queueName = consumer.getQueueName();
                    String queueAppIds = queueAppMap.get(queueName);
                    if (this.isDeployCurrentApp(queueAppIds, appId) && consumer.isStarted()) {
                        consumersWithAppGroup.putIfAbsent(queueName, consumer);
                        String standardQueueName = queueNameMap.get(queueName);
                        try {
                            MQGrayManager mqGrayManager2 = MQGrayManager.get(region2);
                            long consumerCount = mqGrayManager2.consumerCount(region2, standardQueueName);
                            if (consumerCount <= 0L) continue;
                            hasConsumer = true;
                        }
                        catch (Exception e) {
                            ExceptionLogger.warn("query queue consumers error when gray to production,queue name: " + standardQueueName, e);
                        }
                        continue;
                    }
                    allConsumer.remove(i);
                }
                if (!hasConsumer) {
                    ConsumerSupport.setOldStandrandConsumerFinished(appId, appGroup);
                    break;
                }
                LockSupport.parkNanos(1000000000L);
                if (times++ <= Integer.getInteger("mq.upgrade.wait.oldqueuetofinish", 300)) continue;
                break;
            }
            for (Map.Entry next : consumersWithAppGroup.entrySet()) {
                String queueNameWithAppGroup = (String)next.getKey();
                Consumer consumer = (Consumer)next.getValue();
                region = consumer.getRegion();
                try {
                    String standardQueueName = queueNameMap.get(queueNameWithAppGroup);
                    QueueManager.putQueueDefForGray(standardQueueName, QueueManager.getQueueDefWithRealQueueName(region, queueNameWithAppGroup));
                    mqGrayManager = MQGrayManager.get(region);
                    Consumer registerConsumer = mqGrayManager.registerConsumer(region, standardQueueName, consumer.isAutoAck(), consumer.getConcurrency(), consumer.getMessageConsumer(), consumer.getMaxQueueLength());
                    QueueManager.putConsumerForGray(standardQueueName, registerConsumer);
                }
                catch (Exception e) {
                    ExceptionLogger.warn("start standard queue error when gray to production", e);
                }
            }
            PublisherSupport.$$changePublishMessage(appId);
            ConsumerSupport.setFreeWaitPublishForAccrossNode(appId);
            List<Consumer> needDelete = this.waitForConsumeFinish(new ArrayList<Object>(consumersWithAppGroup.values()), appId);
            for (Consumer consumer : needDelete) {
                region = consumer.getRegion();
                String queueName = consumer.getQueueName();
                try {
                    mqGrayManager = MQGrayManager.get(region);
                    mqGrayManager.deleteQueue(region, consumer.getQueueName());
                    consumer.$$stop();
                }
                catch (Exception e) {
                    ExceptionLogger.warn("queue delete exception when gray to product, queue name: " + queueName, e);
                }
            }
            MQGrayManager.releaseResource();
        });
    }

    private List<Consumer> waitForConsumeFinish(List<Object> consumers, String appId) {
        Map<String, String> queueAppMap = QueueManager.getQueueAppMap();
        ArrayList<Consumer> needStopConsumers = new ArrayList<Consumer>(16);
        int times = 0;
        do {
            int size = consumers.size();
            for (int i = size - 1; i >= 0; --i) {
                Object value = consumers.get(i);
                Consumer consumer = (Consumer)value;
                String region = consumer.getRegion();
                String queueName = consumer.getQueueName();
                String queueAppIds = queueAppMap.get(queueName);
                try {
                    if (this.isDeployCurrentApp(queueAppIds, appId) && consumer.isStarted()) {
                        MQGrayManager mqGrayManager = MQGrayManager.get(region);
                        long messageCount = mqGrayManager.messageCount(region, queueName);
                        if (messageCount != 0L) continue;
                        consumers.remove(i);
                        needStopConsumers.add(consumer);
                        continue;
                    }
                    consumers.remove(i);
                    continue;
                }
                catch (Exception e) {
                    ExceptionLogger.warn("error when channel.basicCancel, queue: " + queueName, e);
                }
            }
            if (consumers.size() == 0) break;
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (times++ <= Integer.getInteger("mq.upgrade.wait.oldqueuetofinish", 300));
        return needStopConsumers;
    }

    private boolean isDeployCurrentApp(String queueAppIds, String grayAppId) {
        String[] appIds;
        if (queueAppIds == null) {
            return false;
        }
        for (String appId : appIds = queueAppIds.split(",")) {
            if (!grayAppId.equals(appId)) continue;
            return true;
        }
        return false;
    }
}

