/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.Date;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.jms.JMSDelayManager;
import kd.bos.mq.jms.JMSSessionGroup;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.Consumer;

public class JMSConsumer
implements Consumer {
    private String region;
    private String queue;
    private boolean autoAck;
    private int concurrency;
    private MessageConsumer mc;
    private volatile boolean isStartedFlag;
    private Date startAt;
    private JMSSessionGroup jmsSessionGroup;

    public JMSConsumer(String region, String queue, boolean autoAck, int concurrency, MessageConsumer mc, int maxQueueLength) {
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.concurrency = concurrency;
        this.mc = mc;
    }

    @Override
    public void start() {
        this.isStartedFlag = true;
        this.startAt = new Date();
        try {
            this.jmsSessionGroup = new JMSSessionGroup(this.region, this.queue, this.autoAck, this.concurrency, this.mc);
            this.jmsSessionGroup.startGroupConsumer();
            JMSDelayManager.startDLQConsumer();
        }
        catch (Exception e) {
            ExceptionLogger.log("Can't init consumer for queue " + this.queue, e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"Can't init consumer for queue " + this.queue});
        }
    }

    @Override
    public void $$stop() {
        try {
            this.isStartedFlag = false;
            this.jmsSessionGroup.close();
        }
        catch (Exception e) {
            ExceptionLogger.log("error when stop session " + this.queue, e);
        }
    }

    @Override
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public boolean isStarted() {
        return this.isStartedFlag;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getQueueName() {
        return this.queue;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.mc;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }
}

