/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSProducerFactory;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.util.StringUtils;

public class JMSDLQConsumer
implements MessageListener {
    private static final Log logger = LogFactory.getLog(JMSDLQConsumer.class);
    private Session deadLetterSession;

    JMSDLQConsumer(Session deadLetterSession) {
        this.deadLetterSession = deadLetterSession;
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof BytesMessage) {
                this.resend((BytesMessage)message);
            } else {
                message.acknowledge();
            }
        }
        catch (Exception e) {
            logger.error("MQError:message wrong type, auto discard happen error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resend(BytesMessage message) throws JMSException {
        try (Session session = null;){
            String region = message.getStringProperty("targetRegion");
            String queue = message.getStringProperty("targetQueue");
            if (StringUtils.isNotEmpty((String)region) && StringUtils.isNotEmpty((String)queue)) {
                session = JMSSessionFactory.getSession(region, false);
                MessageProducer messageProducer = JMSProducerFactory.getProducer(session, queue);
                messageProducer.send((Message)message);
            }
            message.acknowledge();
        }
    }
}

