/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import javax.jms.Session;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.jms.JMSPublisher;
import kd.bos.mq.jms.JMSQueueDeclare;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;

public class JMSFactory
extends MQFactory {
    private static Log logger = LogFactory.getLog(JMSFactory.class);

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        if (region == null) {
            throw new KDException(BosErrorCode.jmsmqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueName});
        }
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.jmsmqConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return this._createPublisher(region, queueRealName);
    }

    private MessagePublisher _createPublisher(String region, String queueRealName) {
        try {
            Session session = JMSSessionFactory.getSession(region, false);
            JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
            queueDeclarer.setSession(session);
            queueDeclarer.queueDeclare(region, queueRealName, true, null);
            return new JMSPublisher(session, queueRealName, region);
        }
        catch (Exception t) {
            logger.error("JMSFactory.createSimplePublisher error", (Throwable)t);
            throw new KDException((Throwable)t, BosErrorCode.jmsmqException, new Object[]{"error when create publisher,region:" + region + ",queueName:" + queueRealName});
        }
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        throw new KDException(BosErrorCode.jmsmqException, new Object[]{"can't createPartitionPublisher directly!"});
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef def, String appid) {
        String queueRealName = QueueManager.getRealQueueNameWithAppid(region, def.getName(), appid);
        QueueManager._$defineQueue(region, def, appid);
        return this._createPublisher(region, queueRealName);
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        return this._createPublisher(region, realQueueName);
    }
}

