/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.jms.JMSAdminFactory;
import kd.bos.mq.jms.JMSConsumer;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.MQGrayManager;
import kd.bos.util.ExceptionUtils;

public class JMSGrayManager
implements MQGrayManager {
    private static final Log logger = LogFactory.getLog(JMSGrayManager.class);

    @Override
    public long messageCount(String region, String queueName) {
        try {
            long activeCounter = ConsumerStats.getActiveCount(queueName);
            JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(region);
            long count = JMSAdminFactory.getJMSAdminImpl(jmsInfo.getType()).getQueueMessageSize(jmsInfo, queueName);
            return count + activeCounter;
        }
        catch (Exception e) {
            throw new RuntimeException("JMS MQ: query message count exception, queueName: " + queueName, e);
        }
    }

    @Override
    public long consumerCount(String region, String queueName) {
        try {
            JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(region);
            long count = JMSAdminFactory.getJMSAdminImpl(jmsInfo.getType()).getConsumerCountSize(jmsInfo, queueName);
            return count;
        }
        catch (Exception e) {
            throw new RuntimeException("JMS MQ: query message consumer exception, queueName: " + queueName, e);
        }
    }

    @Override
    public void deleteQueue(String region, String queueName) {
        try {
            JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(region);
            JMSAdminFactory.getJMSAdminImpl(jmsInfo.getType()).deleteQueue(jmsInfo, queueName);
            logger.warn("JMS MQ: delete queue,trace: " + ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception()));
        }
        catch (Exception e) {
            logger.error("JMS MQ: delete queue exception, queueName: " + queueName, (Throwable)e);
        }
    }

    @Override
    public Consumer registerConsumer(String region, String queueName, boolean autoAck, int concurrency, MessageConsumer messageConsumer, int maxQueueLength) {
        try {
            JMSConsumer standardConsumer = new JMSConsumer(region, queueName, autoAck, concurrency, messageConsumer, maxQueueLength);
            standardConsumer.start();
            return standardConsumer;
        }
        catch (Exception e) {
            throw new RuntimeException("start consumer fail,queue=" + queueName, e);
        }
    }

    @Override
    public void shutdown() {
    }
}

