/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSQueueDeclare;
import kd.bos.mq.support.QueueDeclare;

public class JMSProducerFactory {
    private static Log logger = LogFactory.getLog(JMSProducerFactory.class);

    public static MessageProducer getProducer(Session session, String region, String queueRealName) {
        try {
            JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
            queueDeclarer.setSession(session);
            Queue queue = queueDeclarer.getDestination(region, queueRealName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            return producer;
        }
        catch (Exception e) {
            logger.error("create producer error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"error when create producer,region:" + region + ",queueName:" + queueRealName});
        }
    }

    public static MessageProducer getProducer(Session session, String finalQueueName) {
        try {
            JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
            queueDeclarer.setSession(session);
            Queue queue = queueDeclarer.getDestination(finalQueueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(2);
            return producer;
        }
        catch (Exception e) {
            logger.error("create producer error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"error when create producer,queueName:" + finalQueueName});
        }
    }
}

