/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.constant.SceneCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.jms.JMSDelayManager;
import kd.bos.mq.jms.JMSProducerFactory;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class JMSPublisher
extends PublisherSupport {
    private static Log logger = LogFactory.getLog(JMSPublisher.class);
    private static final String JMS_TRACE_NAME = "JMSPublisher";
    private String queueRealName;
    private String region;
    private String vHostQueueName;
    private Session session;
    private MessageProducer producer;

    public JMSPublisher(Session session, String queueRealName, String region) {
        super(false);
        this.vHostQueueName = JMSSessionFactory.getVHostQueueName(region, queueRealName);
        this.session = session;
        this.queueRealName = queueRealName;
        this.region = region;
    }

    @Override
    protected void _beginTrans() {
    }

    @Override
    protected void _commitTrans() {
    }

    @Override
    protected void _rollbackTrans() {
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.publishInDbTranscation(null, message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.publishDelayInDbTranscation(routKey, message, -1);
    }

    private void publishDelayInDbTranscation(String routKey, Object message, int seconds) {
        String writtenRouteKey = TX.getWrittenRouteKey();
        this.publish0(message, null, true, writtenRouteKey == null ? routKey : writtenRouteKey, seconds);
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.publishDelayInDbTranscation(null, message, seconds);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.publish0(message, null, false, null, seconds);
    }

    private void publish0(Object message) {
        this.publish0(message, null, false, null);
    }

    private void publish0(Object message, String consumeSynchronizeTag, boolean indbtrans, String routeKey) {
        this.publish0(message, consumeSynchronizeTag, indbtrans, routeKey, -1);
    }

    private void publish0(Object body, String consumeSynchronizeTag, boolean indbtrans, String routeKey, int seconds) {
        Limiter.checkAndRecord((String)SceneCode.MQ.getCode());
        if (!PublisherSupport.isCanPublishMessage(this.queueRealName)) {
            throw new KDException(BosErrorCode.jmsmqException, new Object[]{"The current node has been discarded due to grayscale completion,queue name is " + this.queueRealName});
        }
        try (TraceSpan span = Tracer.create((String)JMS_TRACE_NAME, (String)"publish0", (boolean)true);){
            span.addTag("queueName", this.queueRealName);
            this.queueRealName = PublisherSupport.getStandardQueue(this.queueRealName);
            Message message = this.toMessage(body);
            message.setConsumeSynchronizeTag(consumeSynchronizeTag);
            if (indbtrans) {
                if (routeKey == null) {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{"routKey  can  not be null"});
                }
                if (KdtxSupport.isDtxEnable()) {
                    this.startDTXAndRegistry(message, routeKey, this.region, this.vHostQueueName);
                    return;
                }
                this.recordMqTrans(routeKey, message);
            }
            DelayControlManager.installDelayInfo(message, seconds);
            byte[] bytes = MessageSerde.get().encode(message);
            this.checkPayload(bytes, this.vHostQueueName);
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(bytes);
            if (message.getStartDeliverTime() > 0L) {
                JMSDelayManager.publishDelayMessage(bytesMessage, seconds, this.region, this.vHostQueueName, this.queueRealName);
            } else {
                if (this.producer == null) {
                    this.producer = JMSProducerFactory.getProducer(this.session, this.region, this.queueRealName);
                }
                bytesMessage.setStringProperty("tag", this.queueRealName);
                this.producer.send((javax.jms.Message)bytesMessage);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"can't send,the reason is " + e.getMessage()});
        }
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        try {
            if (this.producer == null) {
                this.producer = JMSProducerFactory.getProducer(this.session, this.queueRealName);
            }
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(message);
            this.producer.send((javax.jms.Message)bytesMessage);
        }
        catch (Exception e) {
            logger.error("$$publishConfirm error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.jmsmqException, new Object[]{"can't publish"});
        }
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(IDService.get().genLongId());
        message.setMessageTime();
        return message;
    }

    @Override
    public void publish(Object message, String partitionKey) {
        throw new KDException(BosErrorCode.jmsmqException, new Object[]{"SimplePublisher can't publish message with partitionKey directly!"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        throw new KDException(BosErrorCode.jmsmqException, new Object[]{"SimplePublisher can't publishInDbTranscation with partitionKey directly !"});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        throw new KDException(BosErrorCode.jmsmqException, new Object[]{"SimplePublisher can't publishDelay message with partitionKey directly!"});
    }

    @Override
    public void close() {
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            this.session.close();
        }
        catch (JMSException e) {
            throw new KDException(BosErrorCode.jmsmqException, "close error", (Throwable)e);
        }
    }
}

