/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.jms.JMSConsumer;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;

public class JMSQueueDeclare
implements QueueDeclare {
    private static ConcurrentHashMap<String, Queue> queues = new ConcurrentHashMap();
    private Session session;

    @Override
    public void queueDeclare(String region, String queueRealName, boolean isDuration, Map<String, Object> args) {
        String finalQueueName = JMSSessionFactory.getVHostQueueName(region, queueRealName);
        queues.computeIfAbsent(finalQueueName, key -> {
            try {
                return this.session.createQueue(key);
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "declare queue error:", (Throwable)e);
            }
        });
    }

    @Override
    public Consumer getConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef, MessageConsumer mc) {
        int concurrency = QueueManager.getConcurrency(consumerDef);
        JMSConsumer consumer = new JMSConsumer(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength());
        return consumer;
    }

    public Queue getDestination(String region, String queueRealName) {
        String finalQueueName = JMSSessionFactory.getVHostQueueName(region, queueRealName);
        if (!queues.containsKey(finalQueueName)) {
            this.queueDeclare(region, queueRealName, true, null);
        }
        return queues.get(finalQueueName);
    }

    public Queue getDestination(String finalQueueName) {
        return queues.computeIfAbsent(finalQueueName, key -> {
            try {
                return this.session.createQueue(key);
            }
            catch (JMSException e) {
                throw new KDException(BosErrorCode.jmsmqException, "declare queue error:", (Throwable)e);
            }
        });
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

