/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMesPubFactory;
import kd.bos.mq.dlx.DLXStrategy;
import kd.bos.mq.dlx.MessageRecord;
import kd.bos.mq.jms.JMSAcker;
import kd.bos.mq.jms.JMSDelayManager;
import kd.bos.mq.jms.JMSMessageUtil;
import kd.bos.mq.jms.JMSQueueDeclare;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.TimeCacheMap;
import kd.bos.mq.support.TranscationSupport;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public class JMSSessionGroup {
    private static final String MQ_JMS_SAME_QUEUE_MESSAGE_CONCURRENCY_MAX = "mq.jms.same.queue.message.concurrency.max";
    private static final String MQ_JMS_QUEUE_CONCURRENCY_NOT_LIMIT_REGION = "mq.jms.queue.concurrency.notLimit.region";
    private static Counter noRequestContextCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.noRequestContextCounter");
    private static Counter decodeMessageErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.decodeMessageErrorCounter");
    private static Counter handlerMessagerErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerOnMessagerErrorCounter");
    private static Counter handlerMessagerTranscationRollBackCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRollBackCounter");
    private static Counter handlerMessagerTranscationRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRepeateCounter");
    private static Counter handlerMessagerRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerRepeateCounter");
    private static Counter consumerounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.Counter");
    private static Counter activeCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.activeConsumers");
    private static TimeCacheMap<AtomicInteger> messageRepeatTimes = new TimeCacheMap(300);
    private String region;
    private String queue;
    private boolean autoAck;
    private MessageConsumer mc;
    private Session[] sessions;

    JMSSessionGroup(String region, String queue, boolean autoAck, int concurrency, MessageConsumer mc) {
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.mc = mc;
        int maxConcurrency = Integer.getInteger(MQ_JMS_SAME_QUEUE_MESSAGE_CONCURRENCY_MAX, 4);
        String notLimitRegions = System.getProperty(MQ_JMS_QUEUE_CONCURRENCY_NOT_LIMIT_REGION);
        if (StringUtils.isEmpty((String)notLimitRegions) || !notLimitRegions.contains(region)) {
            concurrency = concurrency > maxConcurrency ? maxConcurrency : concurrency;
        }
        this.sessions = new Session[concurrency];
        for (int i = 0; i < concurrency; ++i) {
            this.sessions[i] = JMSSessionFactory.getSession(region, autoAck);
        }
    }

    public void startGroupConsumer() throws JMSException {
        for (int i = 0; i < this.sessions.length; ++i) {
            Session session = this.sessions[i];
            JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
            queueDeclarer.setSession(session);
            Queue destination = queueDeclarer.getDestination(this.region, this.queue);
            String finalQueueName = destination.getQueueName();
            try {
                javax.jms.MessageConsumer consumer = JMSSessionFactory.enableSelector(this.region) ? session.createConsumer((Destination)destination, JMSSessionFactory.getSelector(this.queue)) : session.createConsumer((Destination)destination);
                consumer.setMessageListener(message -> {
                    try {
                        ThreadLifeCycleManager.start();
                        if (message instanceof BytesMessage) {
                            this.innerHandleDelivery(session, finalQueueName, this.autoAck, (BytesMessage)message);
                        } else {
                            message.acknowledge();
                        }
                    }
                    catch (JMSException e) {
                        ExceptionLogger.log("MQError:message consume happen error,queue=" + this.queue, e);
                    }
                    finally {
                        ThreadLifeCycleManager.end();
                    }
                });
                continue;
            }
            catch (RejectedExecutionException e) {
                if (i == 0) {
                    throw e;
                }
                session.close();
            }
        }
    }

    public void close() throws JMSException {
        JMSException exception = null;
        for (int i = 0; i < this.sessions.length; ++i) {
            try {
                this.sessions[i].close();
                continue;
            }
            catch (JMSException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerHandleDelivery(Session session, String finalQueueName, boolean autoAck, BytesMessage bytesMessage) {
        Message message;
        String messageId;
        JMSAcker acker = new JMSAcker(session, (javax.jms.Message)bytesMessage, autoAck);
        try {
            messageId = bytesMessage.getJMSMessageID();
            byte[] body = JMSMessageUtil.covertBytes(bytesMessage);
            message = this.toMessage(body);
        }
        catch (Exception e) {
            acker.discard("");
            decodeMessageErrorCounter.inc();
            ExceptionLogger.log("MQError:toMessage exception, auto discard, queue:" + this.queue, e);
            return;
        }
        if (this.renewDelay()) {
            return;
        }
        if (StringUtils.isNotEmpty((String)message.getKdtxId())) {
            this._handleDtxDelivery(message, acker, bytesMessage);
            return;
        }
        long messageInnerId = message.getInnerId();
        if (messageInnerId != 0L) {
            AtomicInteger ai = messageRepeatTimes.get(messageInnerId);
            if (ai == null) {
                ai = new AtomicInteger(0);
                messageRepeatTimes.put(messageInnerId, ai);
            }
            if (ai.getAndIncrement() > 100) {
                acker.discard(messageId);
                messageRepeatTimes.remove(messageInnerId);
                handlerMessagerRepeateCounter.inc();
                ExceptionLogger.log("MQError:Repeat send message too many times, auto discard, messageId=" + messageId + ",queue=" + this.queue);
                return;
            }
        }
        try {
            this._handleDelivery(session, finalQueueName, bytesMessage.getJMSRedelivered(), messageId, message, acker);
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                int tryTimes = TranscationSupport.instance().tryTimes(String.valueOf(message.getInnerId()));
                if (tryTimes > 30) {
                    acker.discard(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception,try times >30, auto discard, messageId=" + messageId, t);
                } else {
                    this.applyWait(tryTimes);
                    acker.deny(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
                }
            } else {
                ExceptionLogger.log("MQError:handleDelivery uncatched exception, messageId=" + messageId, t);
            }
        }
        finally {
            if (!acker.isDenied()) {
                messageRepeatTimes.remove(messageInnerId);
            }
        }
    }

    private boolean renewDelay() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleDtxDelivery(Message message, JMSAcker acker, BytesMessage bytesMessage) {
        boolean isManual = false;
        DBRoute dbRoute = DBRoute.of((String)message.getRouteKey());
        boolean dbTransEnd = true;
        try {
            boolean redeliver = bytesMessage.getJMSRedelivered();
            String messageId = bytesMessage.getJMSMessageID();
            boolean b = this.createTraceAndRequestContext(message);
            if (!b) {
                acker.discard("");
                KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                ExceptionLogger.log("MQError:message has`t requestContext, auto discard,queueName=" + this.queue);
                noRequestContextCounter.inc();
                return;
            }
            boolean isReceived = KdtxSupport.isReceived(dbRoute, message.getKdtxId(), message.getSeq());
            if (!isReceived) {
                try {
                    KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                }
                catch (Exception e) {
                    acker.deny("");
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "MQError:message update receive statue error, will requeue", true);
                    noRequestContextCounter.inc();
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
                    if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                        if (isManual) {
                            KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                        }
                        KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
                    }
                    return;
                }
            } else if (!redeliver) {
                isManual = KdtxSupport.isManual(message.getKdtxId(), message.getSeq());
                if (!isManual) {
                    acker.discard("");
                    return;
                }
            } else if (KdtxSupport.mqSecondCompensate(message.getKdtxId(), message.getSeq())) {
                acker.discard("");
                return;
            }
            if (message.getKdtxId().equals(message.getTranscationTag())) {
                if (TranscationSupport.instance().isRollBack(message.getTranscationTag())) {
                    acker.isDiscarded();
                    return;
                }
                if (!TranscationSupport.instance().existXid(message.getRouteKey(), message.getTranscationTag())) {
                    acker.isDiscarded();
                    dbTransEnd = false;
                    return;
                }
            }
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), String.format("message[isReceived:%s,isManual:%s] start execute", isReceived, isManual), false);
            RequestContext rc = RequestContext.get();
            if (JMSSessionGroup.isforbiddenTenantCode(rc.getTenantCode())) {
                LockSupport.parkNanos(1000000000L);
                acker.deny("");
                return;
            }
            if (DLXConfig.isSendDLX(message.getRequestContext())) {
                message.setDLXMessage(true);
                DLXMesPubFactory.getDLXMessagePublisher().sendMessage(this.region, this.queue, message, messageId, acker);
                return;
            }
            this.doTraceAndConsume(redeliver, messageId, message, acker);
            if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
                MessageRecord.update(2, message.getInnerId());
            }
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                this.applyWait(1);
                acker.deny("");
                KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "common exception auto deny,errorMsg:" + t.getMessage(), true);
            }
            ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny", t);
        }
        finally {
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
            if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                if (isManual) {
                    KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                }
                KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
            }
        }
    }

    private void _handleDelivery(Session session, String finalQueueName, boolean redeliver, String messageId, Message message, JMSAcker acker) {
        boolean b = this.createTraceAndRequestContext(message);
        if (!b) {
            acker.discard("");
            ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
            noRequestContextCounter.inc();
            return;
        }
        RequestContext rc = RequestContext.get();
        if (JMSSessionGroup.isforbiddenTenantCode(rc.getTenantCode())) {
            LockSupport.parkNanos(1000000000L);
            acker.deny("");
            return;
        }
        if (DLXConfig.isSendDLX(message.getRequestContext())) {
            message.setDLXMessage(true);
            DLXMesPubFactory.getDLXMessagePublisher().sendMessage(this.region, this.queue, message, messageId, acker);
            return;
        }
        if (!this.isTransactionSubmit(session, finalQueueName, messageId, message, acker)) {
            return;
        }
        this.doTraceAndConsume(redeliver, messageId, message, acker);
        if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
            MessageRecord.update(2, message.getInnerId());
        }
    }

    private boolean isTransactionSubmit(Session session, String finalQueueName, String messageId, Message message, JMSAcker acker) {
        String xid = message.getTranscationTag();
        if (xid != null && !this.autoAck) {
            boolean existXid;
            int loop = -1;
            int max = 3;
            do {
                if (TranscationSupport.instance().isRollBack(xid)) {
                    acker.discard("");
                    handlerMessagerTranscationRollBackCounter.inc();
                    return false;
                }
                existXid = TranscationSupport.instance().existXid(message.getRouteKey(), xid);
                if (max == ++loop) break;
                this.applyWait(loop);
            } while (!existXid);
            if (!existXid) {
                this.waitDeal(session, finalQueueName, messageId, message, acker, xid);
                return false;
            }
            String messageRouteKey = message.getRouteKey();
            String consumeRouteKey = this.mc.getRouteKey();
            if (consumeRouteKey == null) {
                consumeRouteKey = messageRouteKey;
            }
            if (TranscationSupport.instance().existConsumedId(consumeRouteKey, xid)) {
                acker.discard("");
                handlerMessagerTranscationRepeateCounter.inc();
                return false;
            }
            String _consumeRouteKey = consumeRouteKey;
            acker.setAckedCallBack(() -> {
                try {
                    TranscationSupport.instance().insertConsumed(_consumeRouteKey, xid);
                    TranscationSupport.instance().deleteXid(messageRouteKey, xid);
                }
                catch (Exception e) {
                    ExceptionLogger.log("mq TranscationSupport error of ack", e);
                }
            });
        }
        return true;
    }

    private void waitDeal(Session session, String finalQueueName, String messageId, Message message, JMSAcker acker, String xid) {
        if (message.getRetryTimes() != -1) {
            this.delayStrategy(session, finalQueueName, messageId, message, acker);
        } else {
            this.timesStrategy(messageId, message, acker, xid);
        }
    }

    private void delayStrategy(Session session, String finalQueueName, String messageId, Message message, JMSAcker acker) {
        int retryTimes = message.getRetryTimes();
        if (retryTimes >= 13) {
            acker.discard(messageId);
        } else {
            int nextDelayLevel = retryTimes + 3;
            message.setRetryTimes(retryTimes + 1);
            byte[] bytes = MessageSerde.get().encode(message);
            MetaTime delayLevel = MetaTime.genInstanceByLevel(nextDelayLevel);
            if (delayLevel != null) {
                try {
                    BytesMessage bytesMessage = session.createBytesMessage();
                    bytesMessage.writeBytes(bytes);
                    JMSDelayManager.publishDelayMessage(bytesMessage, delayLevel.getMillis() / 1000, this.region, finalQueueName, this.queue);
                    acker.discard(messageId);
                }
                catch (Exception e) {
                    acker.deny(messageId);
                    ExceptionLogger.log("publishDelayMessageConfirmModel for queue " + this.queue + " error ", e);
                }
            }
        }
    }

    private void timesStrategy(String messageId, Message message, JMSAcker acker, String xid) {
        int tryTimes = TranscationSupport.instance().tryTimes(xid);
        if (tryTimes > 30 || this.isMessageTimeout(message)) {
            acker.discard(messageId);
            handlerMessagerTranscationRollBackCounter.inc();
        } else {
            this.applyWait(tryTimes);
            acker.deny(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTraceAndConsume(boolean redeliver, String messageId, Message message, JMSAcker acker) {
        try (TraceSpan span = Tracer.create((String)"MQConsumer", (String)"onMessage", (boolean)true);){
            span.addTag("messageId", messageId);
            span.addTag("resent", Boolean.toString(redeliver));
            span.addTag("queue", this.queue);
            span.addTag("region", this.region);
            try {
                activeCounter.inc();
                ConsumerStats.incrementActiveCount(this.queue, messageId);
                this.mc.onMessage(message.getBody(), messageId, redeliver, acker);
                if (!acker.hasDone()) {
                    acker.ack(messageId);
                }
            }
            catch (Exception t) {
                if (!acker.hasDone()) {
                    handlerMessagerErrorCounter.inc();
                    ExceptionLogger.log("MQError:onMessage uncatched exception, auto discard, messageId=" + messageId, t);
                    acker.discard(messageId);
                } else {
                    ExceptionLogger.log("MQError:onMessage uncatched exception, messageId=" + messageId, t);
                }
            }
            finally {
                activeCounter.dec();
                ConsumerStats.decrementActiveCount(this.queue, messageId);
            }
        }
    }

    private boolean isMessageTimeout(Message message) {
        long timeout = (long)Integer.parseInt(System.getProperty("mq.trasncation.message.waittime", "300")) * 1000L;
        return System.currentTimeMillis() - message.getMessageTime() > timeout;
    }

    private boolean createTraceAndRequestContext(Message message) {
        RequestContext rc = message.getRequestContext();
        if (rc == null) {
            return false;
        }
        String traceId = TraceIdUtil.createTraceIdString();
        rc.setTraceId(traceId);
        RequestContextCreator.restoreForMQ((RequestContext)rc);
        return true;
    }

    private void applyWait(int tryTimes) {
        if (tryTimes < 1) {
            return;
        }
        if (tryTimes == 1) {
            LockSupport.parkNanos(100000000L);
        } else {
            LockSupport.parkNanos(1000000000L * (long)tryTimes);
        }
    }

    private Message toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    private static boolean isforbiddenTenantCode(String tenantCode) {
        if (Instance.isPausedServiceByMonitor()) {
            return true;
        }
        String fbStr = System.getProperty("mq.consume.forbidden.tenantcodes");
        if (fbStr == null) {
            return false;
        }
        String[] fbTenantCodes = fbStr.split(",|;");
        if (fbTenantCodes == null) {
            return false;
        }
        for (String fbcode : fbTenantCodes) {
            if (!tenantCode.equalsIgnoreCase(fbcode)) continue;
            return true;
        }
        return false;
    }
}

