/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.delay;

import java.util.concurrent.locks.LockSupport;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.JMSMessageUtil;
import kd.bos.mq.jms.JMSProducerFactory;
import kd.bos.mq.jms.JMSQueueDeclare;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.jms.delay.JMSInnerDelayManager;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.util.StringUtils;

public class JMSInnerDelayConsumer
implements MessageListener {
    private static final Log logger = LogFactory.getLog(JMSInnerDelayConsumer.class);
    private String serverKey;
    private String queueName;
    private Session delaySession;
    private int millsDuration;

    public JMSInnerDelayConsumer(String serverKey, String queueName, int duration) {
        this.serverKey = serverKey;
        this.queueName = queueName;
        this.millsDuration = duration;
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof BytesMessage) {
                this.dispatch((BytesMessage)message);
            } else {
                message.acknowledge();
            }
        }
        catch (Exception e) {
            logger.error("MQError:message wrong type, auto discard happen error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(BytesMessage bytesMessage) throws JMSException {
        try (Session session = null;){
            String region = bytesMessage.getStringProperty("targetRegion");
            String finalQueueName = bytesMessage.getStringProperty("targetQueue");
            String originTag = bytesMessage.getStringProperty("targetTag");
            long startDeliverTime = bytesMessage.getLongProperty("startDeliverTime");
            long enterQueueTime = bytesMessage.getLongProperty("enterQueueTime");
            boolean queueTimeout = System.currentTimeMillis() - enterQueueTime >= (long)this.millsDuration;
            boolean messageTimeout = System.currentTimeMillis() - startDeliverTime >= 0L;
            int remainSeconds = (int)(startDeliverTime - System.currentTimeMillis()) / 1000;
            byte[] body = JMSMessageUtil.covertBytes(bytesMessage);
            session = JMSSessionFactory.getSessionByServerKey(this.serverKey, false);
            BytesMessage bytesMessageNew = session.createBytesMessage();
            bytesMessageNew.writeBytes(body);
            if (StringUtils.isNotEmpty((String)region) && StringUtils.isNotEmpty((String)finalQueueName)) {
                if (messageTimeout) {
                    this.sendTarget(bytesMessageNew, region, finalQueueName, originTag);
                } else if (queueTimeout) {
                    JMSInnerDelayManager.publishDelayMessage(bytesMessageNew, remainSeconds, region, finalQueueName, originTag);
                } else {
                    LockSupport.parkNanos(500000000L);
                    this.delaySession.recover();
                    return;
                }
            }
            bytesMessage.acknowledge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTarget(BytesMessage bytesMessage, String region, String finalQueueName, String originTag) throws JMSException {
        try (Session session = null;){
            session = JMSSessionFactory.getSession(region, false);
            bytesMessage.setStringProperty("tag", originTag);
            MessageProducer messageProducer = JMSProducerFactory.getProducer(session, finalQueueName);
            messageProducer.send((Message)bytesMessage);
            messageProducer.close();
            session.close();
        }
    }

    public void start() throws JMSException {
        this.delaySession = JMSSessionFactory.getSessionByServerKey(this.serverKey, false);
        JMSQueueDeclare queueDeclarer = (JMSQueueDeclare)QueueDeclare.get("jms");
        queueDeclarer.setSession(this.delaySession);
        Queue destination = queueDeclarer.getDestination("delayRegion", this.queueName);
        MessageConsumer consumer = JMSSessionFactory.enableSelectorByServerKey(this.serverKey) ? this.delaySession.createConsumer((Destination)destination, JMSSessionFactory.getSelector(this.queueName)) : this.delaySession.createConsumer((Destination)destination);
        consumer.setMessageListener((MessageListener)this);
    }

    public void stop() throws JMSException {
        if (this.delaySession != null) {
            this.delaySession.close();
        }
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getServerKey() {
        return this.serverKey;
    }
}

