/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.delay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.jms.JMSProducerFactory;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.jms.delay.JMSInnerDelayConsumer;

public class JMSInnerDelayManager {
    public static final String delayRegion = "delayRegion";
    public static final String START_DELIVER_TIME = "startDeliverTime";
    public static final String ENTER_QUEUE_TIME = "enterQueueTime";
    public static final String ORIGIN_TAG = "targetTag";
    private static Log logger = LogFactory.getLog(JMSInnerDelayManager.class);
    private static Map<String, List<JMSInnerDelayConsumer>> consumers = new HashMap<String, List<JMSInnerDelayConsumer>>();
    private static Map<String, AtomicBoolean> startedServerKeys = new HashMap<String, AtomicBoolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishDelayMessage(BytesMessage bytesMessage, int seconds, String region, String finalQueueName, String tag) throws JMSException {
        Session session = null;
        MessageProducer producer = null;
        try {
            MetaTime metaTime = DelayControlManager.selectMaxMetaTime(seconds);
            session = JMSSessionFactory.getSession(region, false);
            producer = JMSProducerFactory.getProducer(session, delayRegion, metaTime.getName());
            bytesMessage.setStringProperty(ORIGIN_TAG, tag);
            bytesMessage.setStringProperty("targetRegion", region);
            bytesMessage.setStringProperty("targetQueue", finalQueueName);
            bytesMessage.setLongProperty(START_DELIVER_TIME, DelayControlManager.convertTime(seconds));
            bytesMessage.setLongProperty(ENTER_QUEUE_TIME, System.currentTimeMillis());
            bytesMessage.setStringProperty("tag", metaTime.getName());
            producer.send((Message)bytesMessage);
        }
        finally {
            if (producer != null) {
                producer.close();
            }
            if (session != null) {
                session.close();
            }
        }
    }

    public static void start(String serverKey) {
        AtomicBoolean shardStarted = startedServerKeys.computeIfAbsent(serverKey, key -> new AtomicBoolean(false));
        if (shardStarted.compareAndSet(false, true)) {
            MetaTime[] metaTimes;
            for (MetaTime metaTime : metaTimes = MetaTime.values()) {
                try {
                    JMSInnerDelayConsumer innerDelayConsumer = new JMSInnerDelayConsumer(serverKey, metaTime.getName(), metaTime.getMillis());
                    innerDelayConsumer.start();
                    consumers.computeIfAbsent(serverKey, k -> new ArrayList()).add(innerDelayConsumer);
                }
                catch (Exception e) {
                    logger.error("start delay queue {} error", (Object)metaTime.getName(), (Object)e);
                }
            }
        }
    }

    public static void stop() {
        for (Map.Entry<String, List<JMSInnerDelayConsumer>> entry : consumers.entrySet()) {
            AtomicBoolean shardStarted = startedServerKeys.get(entry.getKey());
            if (shardStarted == null || !shardStarted.compareAndSet(true, false)) continue;
            for (JMSInnerDelayConsumer consumer : entry.getValue()) {
                try {
                    consumer.stop();
                }
                catch (Exception e) {
                    logger.error("stop delay queue {} error", (Object)consumer.getQueueName(), (Object)e);
                }
            }
        }
    }

    public static void restart() {
        startedServerKeys.keySet().forEach(JMSInnerDelayManager::start);
    }
}

