/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.jms.reconnect;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.jms.reconnect.JMSReconnectCallback;

public class AutoReconnectAdapter
implements ExceptionListener {
    private static Log logger = LogFactory.getLog(AutoReconnectAdapter.class);
    private static final long START_RECONNECTDELAY = 2L;
    private static final long MAX_RECONNECT_DELAY = 128L;
    private static final ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);
    private long reconnectDelay = 2L;
    private final JMSReconnectCallback jmsReconnectCallback;

    public AutoReconnectAdapter(JMSReconnectCallback jmsReconnectCallback) {
        this.jmsReconnectCallback = jmsReconnectCallback;
    }

    public void onException(JMSException exception) {
        if (null != this.jmsReconnectCallback) {
            try {
                this.jmsReconnectCallback.onConnectionLost();
                this.scheduleReconnectCycle();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void attemptReconnect() {
        if (null != this.jmsReconnectCallback) {
            try {
                this.jmsReconnectCallback.tryReconnecting();
                this.reconnectDelay = 2L;
            }
            catch (Exception e) {
                if (e instanceof JMSException || e.getCause() instanceof JMSException) {
                    this.reconnectDelay = Math.min(this.reconnectDelay * 2L, 128L);
                    this.scheduleReconnectCycle();
                }
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void scheduleReconnectCycle() {
        logger.info("Scheduling reconnect timer, delay {} seconds", (Object)this.reconnectDelay);
        schedule.schedule(this::attemptReconnect, this.reconnectDelay, TimeUnit.SECONDS);
    }
}

