/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.mq.kafka.KafkaTopicManager;
import kd.bos.mq.kafka.PollThread;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

class CommitThread
extends Thread {
    private String appId;
    private CopyOnWriteArraySet<String> topicSet;
    private KafkaConsumer<String, byte[]> consumer;
    private ReentrantLock syncLock;
    private PollThread pollThread;

    public CommitThread(String threadName, String appId, KafkaConsumer<String, byte[]> consumer, ReentrantLock reentrantLock, PollThread pollThread) {
        this.setName(threadName);
        this.appId = appId;
        this.consumer = consumer;
        this.topicSet = KafkaTopicManager.getTopicSet(appId);
        this.syncLock = reentrantLock;
        this.pollThread = pollThread;
    }

    @Override
    public void run() {
        while (this.topicSet.size() > 0) {
            Map<TopicPartition, OffsetAndMetadata> offsetMap;
            this.topicSet = KafkaTopicManager.getTopicSet(this.appId);
            if (this.topicSet == null || this.topicSet.size() == 0) {
                while (true) {
                    if ((offsetMap = this.pollThread.pollOffset()) == null) {
                        return;
                    }
                    this.syncSubmit(offsetMap);
                }
            }
            offsetMap = this.pollThread.pollOffset();
            if (offsetMap == null) continue;
            this.syncSubmit(offsetMap);
        }
    }

    private void syncSubmit(Map<TopicPartition, OffsetAndMetadata> offsetMap) {
        try {
            this.syncLock.lock();
            this.consumer.commitSync(offsetMap);
        }
        finally {
            this.syncLock.unlock();
        }
    }
}

