/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.broadcast.Configure;
import kd.bos.mq.broadcast.MessageReceive;
import kd.bos.mq.kafka.ConsumerFactory;
import kd.bos.mq.kafka.ProducerFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaBroadcast
extends Broadcast {
    private static final String BROADCAST_REGION = "broadcast";
    private static final String BROADCAST_QUEUE = "broadcast_queue_" + Instance.getClusterName() + System.getProperty("mq.debug.queue.tag", "");
    private static final Log logger = LogFactory.getLog(KafkaBroadcast.class);
    private static Map<String, KafkaConsumer<String, byte[]>> MQConsumerMap = new ConcurrentHashMap<String, KafkaConsumer<String, byte[]>>(8);

    private static void regist() {
        if (MQConsumerMap.get(BROADCAST_QUEUE) != null) {
            return;
        }
        String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
        String topicName = KafkaBroadcast.getTopicName(kafkaInfo.getVhost(), BROADCAST_QUEUE);
        new Thread(() -> {
            KafkaConsumer<String, byte[]> mqConsumer = ConsumerFactory.getBroadcastConsumer(BROADCAST_REGION, BROADCAST_QUEUE, Instance.getInstanceId());
            MQConsumerMap.put(BROADCAST_QUEUE, mqConsumer);
            block3: while (true) {
                ConsumerRecords consumerRecords;
                if ((consumerRecords = mqConsumer.poll(Duration.ofMillis(100L))).isEmpty()) {
                    continue;
                }
                try {
                    Iterator iterator = consumerRecords.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        ConsumerRecord record = (ConsumerRecord)iterator.next();
                        MessageReceive.instance().onMessage((byte[])record.value());
                    }
                }
                finally {
                    mqConsumer.commitSync();
                    continue;
                }
                break;
            }
        }, "kafkaBroadcastConsumer-" + topicName).start();
    }

    private static void regist(String appId) {
        if (MQConsumerMap.get(appId) != null) {
            return;
        }
        String serverKey = ProducerFactory.getRegionServerKey(KafkaBroadcast.getAppRegion(appId));
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
        String topicName = KafkaBroadcast.getTopicName(kafkaInfo.getVhost(), KafkaBroadcast.getBroadcastQueue(appId));
        new Thread(() -> {
            KafkaConsumer<String, byte[]> mqConsumer = ConsumerFactory.getBroadcastConsumer(KafkaBroadcast.getAppRegion(appId), KafkaBroadcast.getBroadcastQueue(appId), Instance.getInstanceId() + "_" + appId);
            MQConsumerMap.put(appId, mqConsumer);
            block3: while (true) {
                ConsumerRecords consumerRecords;
                if ((consumerRecords = mqConsumer.poll(Duration.ofMillis(100L))).isEmpty()) {
                    continue;
                }
                try {
                    Iterator iterator = consumerRecords.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        ConsumerRecord record = (ConsumerRecord)iterator.next();
                        MessageReceive.instance().onMessage((byte[])record.value());
                    }
                }
                finally {
                    mqConsumer.commitSync();
                    continue;
                }
                break;
            }
        }, "kafkaBroadcastConsumer-" + appId + "-" + topicName).start();
    }

    private static String getAppRegion(String appId) {
        return "broadcast_" + appId;
    }

    private static String getBroadcastQueue(String appId) {
        return BROADCAST_QUEUE + '_' + appId;
    }

    private static String getTopicName(String vhost, String queueName) {
        return (vhost + '_' + queueName).replace('.', '-');
    }

    @Override
    public void registerBroadcastConsumer() {
        KafkaBroadcast.regist();
        try {
            if (!Instance.isAppSplit()) {
                return;
            }
            String[] appIds = Instance.getAppIds();
            if (appIds == null) {
                return;
            }
            Set<String> supportedAppids = Configure.getSupportBroadcastAppids();
            for (String appId : appIds) {
                if (!supportedAppids.contains(appId)) continue;
                KafkaBroadcast.regist(appId);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"can't init KafkaBroadcastConsumer"});
        }
    }

    @Override
    public void broadcastMessage(byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        try {
            String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
            KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
            String topicName = KafkaBroadcast.getTopicName(kafkaInfo.getVhost(), BROADCAST_QUEUE);
            KafkaProducer<String, byte[]> producer = ProducerFactory.getProducer(BROADCAST_REGION, BROADCAST_QUEUE, kafkaInfo);
            ProducerRecord record = new ProducerRecord(topicName, (Object)message);
            producer.send(record);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"boradcastMessage can't send" + e.getMessage()});
        }
    }

    @Override
    public void broadcastMessage(String appId, byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        if (!Configure.getSupportBroadcastAppids().contains(appId)) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"app" + appId + " not support broadcast"});
        }
        try {
            if (Instance.isAppSplit()) {
                String region = KafkaBroadcast.getAppRegion(appId);
                String serverKey = ProducerFactory.getRegionServerKey(region);
                KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
                KafkaProducer<String, byte[]> producer = ProducerFactory.getProducer(region, KafkaBroadcast.getBroadcastQueue(appId), kafkaInfo);
                String topicName = KafkaBroadcast.getTopicName(kafkaInfo.getVhost(), KafkaBroadcast.getBroadcastQueue(appId));
                ProducerRecord record = new ProducerRecord(topicName, (Object)message);
                producer.send(record);
            } else {
                String serverKey = ProducerFactory.getRegionServerKey(BROADCAST_REGION);
                KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
                String topicName = KafkaBroadcast.getTopicName(kafkaInfo.getVhost(), BROADCAST_QUEUE);
                KafkaProducer<String, byte[]> producer = ProducerFactory.getProducer(BROADCAST_REGION, BROADCAST_QUEUE, kafkaInfo);
                ProducerRecord record = new ProducerRecord(topicName, (Object)message);
                producer.send(record);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.kafkaException, new Object[]{"boradcastMessage can't send,appid" + appId + ",errorMessage" + e.getMessage()});
        }
    }

    private boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }
}

