/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.Properties;
import kd.bos.kafka.KafkaInfo;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.util.StringUtils;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class KafkaConfig {
    static Properties getProducerConfig(KafkaInfo kafkaInfo) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", kafkaInfo.getHost());
        properties.put("key.serializer", ByteArraySerializer.class.getName());
        properties.put("value.serializer", ByteArraySerializer.class.getName());
        properties.put("max.request.size", (Object)PublisherSupport.MQ_MESSAGE_PAYLOAD_VALUE);
        properties.put("max.block.ms", "30000");
        properties.put("request.timeout.ms", "30000");
        properties.put("retries", "2");
        properties.put("acks", "all");
        KafkaConfig.putAuthConfig(kafkaInfo, properties);
        return properties;
    }

    public static Properties getConsumerConfig(KafkaInfo kafkaInfo) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", kafkaInfo.getHost());
        properties.put("key.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.put("enable.auto.commit", "false");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.records", "10");
        properties.put("request.timeout.ms", "30000");
        properties.put("max.poll.interval.ms", "600000");
        KafkaConfig.putAuthConfig(kafkaInfo, properties);
        return properties;
    }

    static Properties getAdminConfig(KafkaInfo kafkaInfo) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", kafkaInfo.getHost());
        properties.setProperty("request.timeout.ms", "30000");
        KafkaConfig.putAuthConfig(kafkaInfo, properties);
        return properties;
    }

    private static void putAuthConfig(KafkaInfo kafkaInfo, Properties properties) {
        if (StringUtils.isEmpty((String)kafkaInfo.getSecurityProtocol())) {
            return;
        }
        String securityProtocol = kafkaInfo.getSecurityProtocol();
        properties.put("security.protocol", securityProtocol);
        if (securityProtocol.equals("SASL_PLAINTEXT")) {
            properties.put("sasl.mechanism", kafkaInfo.getSaslMechanism());
            properties.put("sasl.jaas.config", kafkaInfo.getSaslJaasConfig());
        } else if (securityProtocol.equals("SASL_SSL")) {
            properties.put("sasl.mechanism", kafkaInfo.getSaslMechanism());
            properties.put("sasl.jaas.config", kafkaInfo.getSaslJaasConfig());
            properties.put("ssl.truststore.location", kafkaInfo.getSslTruststoreLocation());
            properties.put("ssl.truststore.password", kafkaInfo.getSslTruststorePassword());
            properties.put("ssl.endpoint.identification.algorithm", kafkaInfo.getSslEndpointIdentificationAlgorithm());
            if (StringUtils.isNotEmpty((String)kafkaInfo.getSslKeystoreType()) && StringUtils.isNotEmpty((String)kafkaInfo.getSslKeystoreLocation()) && StringUtils.isNotEmpty((String)kafkaInfo.getSslKeystorePassword())) {
                properties.put("ssl.keystore.type", kafkaInfo.getSslKeystoreType());
                properties.put("ssl.keystore.location", kafkaInfo.getSslKeystoreLocation());
                properties.put("ssl.keystore.password", kafkaInfo.getSslKeystorePassword());
            }
        } else if (securityProtocol.equals("SSL")) {
            properties.put("ssl.truststore.location", kafkaInfo.getSslTruststoreLocation());
        }
    }
}

