/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class KafkaConsumerWorkerPool {
    private static final int THREAD_SIZE = Integer.parseInt(System.getProperty("mq.kafka.consumer.worker.pool.size", "128"));
    private static final Integer MAX_FIX_QUEUESIZE = Integer.getInteger("threadpool.fix.maxqueue.size", 10000);
    private static final ExecutorService WORKER_POOL = new ThreadPoolExecutor(THREAD_SIZE, THREAD_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(MAX_FIX_QUEUESIZE), new ThreadFactory(){
        private final AtomicInteger atomicInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "kafkaWorker-" + this.atomicInteger.incrementAndGet());
        }
    }, new ThreadPoolExecutor.DiscardOldestPolicy());

    public static void execute(Runnable runnable) {
        WORKER_POOL.execute(runnable);
    }
}

