/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.kafka.ClassCastUtil;
import kd.bos.mq.kafka.KafkaConfig;
import kd.bos.mq.kafka.KafkaDelayManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;

class KafkaDelayConsumer {
    private static final Log LOGGER = LogFactory.getLog(KafkaDelayConsumer.class);
    private String delayTopicLevel;
    private List<MetaTime> metaTimeList;
    private KafkaConsumer<String, byte[]> consumer;
    private String groupId;
    private CountDownLatch countDownLatch;
    private volatile boolean isRunning;
    private Map<String, Integer> topic2unitsecondsMap;

    public KafkaDelayConsumer(String delayTopicLevel, List<MetaTime> metaTimeList, String groupId, CountDownLatch countDownLatch) {
        this.delayTopicLevel = delayTopicLevel;
        this.metaTimeList = metaTimeList;
        this.groupId = groupId;
        this.countDownLatch = countDownLatch;
        this.topic2unitsecondsMap = new HashMap<String, Integer>(metaTimeList.size());
        for (MetaTime tempMetaTime : metaTimeList) {
            this.topic2unitsecondsMap.put(KafkaDelayManager.getDelayTopicName(tempMetaTime.getName()), tempMetaTime.getMillis() / 1000);
        }
    }

    private List<String> getDelayTopicList() {
        ArrayList<String> topicList = new ArrayList<String>(this.metaTimeList.size());
        this.metaTimeList.stream().forEach(metaTime -> topicList.add(KafkaDelayManager.getDelayTopicName(metaTime.getName())));
        return topicList;
    }

    private long getPollTimeoutMillis() {
        if (this.delayTopicLevel.equals(KafkaDelayManager.DELAYTOPIC_LEVEL_LOW)) {
            return Long.getLong("mq.kafka.low.delayconsumer.poll.timeout", 500L);
        }
        return Long.getLong("mq.kafka.high.delayconsumer.poll.timeout", 1000L);
    }

    private long getUnexpiredRecordWaitMillis() {
        if (this.delayTopicLevel.equals(KafkaDelayManager.DELAYTOPIC_LEVEL_LOW)) {
            return Long.getLong("mq.kafka.low.delayconsumer.poll.unexpired.wait", 500L);
        }
        return Long.getLong("mq.kafka.high.delayconsumer.poll.unexpired.wait", 4000L);
    }

    public void start() {
        this.isRunning = true;
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)"mq.server");
        Properties properties = KafkaConfig.getConsumerConfig(kafkaInfo);
        properties.put("group.id", this.groupId);
        this.consumer = new KafkaConsumer(properties);
        this.consumer.subscribe(this.getDelayTopicList());
        this.countDownLatch.countDown();
        block2: while (this.isRunning) {
            ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(this.getPollTimeoutMillis()));
            if (consumerRecords.isEmpty()) continue;
            for (ConsumerRecord record : consumerRecords) {
                byte[] value = (byte[])record.value();
                try {
                    Map<String, Object> recordHeaderMap = this.getRecordHeaderMap((ConsumerRecord<String, byte[]>)record);
                    String targetTopic = recordHeaderMap.get("targetTopic").toString();
                    byte[] startDeliverTimeByteArray = (byte[])recordHeaderMap.get("startDeliverTime");
                    long startDeliverTime = ClassCastUtil.byteArrayToLong(startDeliverTimeByteArray);
                    byte[] retryTimesBytes = null;
                    if (recordHeaderMap.containsKey("retryTimes")) {
                        retryTimesBytes = (byte[])recordHeaderMap.get("retryTimes");
                    }
                    String deplyTopic = record.topic();
                    int unitSeconds = this.topic2unitsecondsMap.get(deplyTopic);
                    long recordCreateTimestamp = record.timestamp();
                    int storeRemainSeconds = (int)(recordCreateTimestamp + (long)(unitSeconds * 1000) - System.currentTimeMillis()) / 1000;
                    if (storeRemainSeconds > 0) {
                        TopicPartition topicPartition = new TopicPartition(deplyTopic, record.partition());
                        this.consumer.seek(topicPartition, record.offset());
                        Thread.currentThread();
                        Thread.sleep(this.getUnexpiredRecordWaitMillis());
                        continue block2;
                    }
                    int remainSeconds = (int)(startDeliverTime - System.currentTimeMillis()) / 1000;
                    String nextTopic = "";
                    if (remainSeconds > 0) {
                        MetaTime metaTime = DelayControlManager.selectMaxMetaTime(remainSeconds);
                        if (metaTime == MetaTime.delay_1s && unitSeconds == 1) {
                            Thread.currentThread();
                            Thread.sleep(500L);
                            TopicPartition topicPartition = new TopicPartition(deplyTopic, record.partition());
                            this.consumer.seek(topicPartition, record.offset());
                            continue;
                        }
                        nextTopic = KafkaDelayManager.getDelayTopicName(metaTime.getName());
                    } else {
                        nextTopic = targetTopic;
                    }
                    this.dispatchMessage(nextTopic, value, targetTopic, startDeliverTimeByteArray, retryTimesBytes);
                    HashMap<TopicPartition, OffsetAndMetadata> partitionOffSetMap = new HashMap<TopicPartition, OffsetAndMetadata>();
                    partitionOffSetMap.put(new TopicPartition(deplyTopic, record.partition()), new OffsetAndMetadata(record.offset() + 1L));
                    this.consumer.commitSync(partitionOffSetMap);
                }
                catch (Exception e) {
                    LOGGER.error("kafkaDelayConsumer handle error ", (Throwable)e);
                }
            }
        }
    }

    private void dispatchMessage(String nextTopic, byte[] value, String targetTopic, byte[] startDeliverTimeByteArray, byte[] retryTimesBytes) throws InterruptedException, ExecutionException {
        ProducerRecord nextRecord = new ProducerRecord(nextTopic, (Object)value);
        nextRecord.headers().add("targetTopic", targetTopic.getBytes());
        nextRecord.headers().add("startDeliverTime", startDeliverTimeByteArray);
        if (retryTimesBytes != null) {
            nextRecord.headers().add("retryTimes", retryTimesBytes);
        }
        KafkaDelayManager.dispatchMessage((ProducerRecord<String, byte[]>)nextRecord).get();
    }

    private Map<String, Object> getRecordHeaderMap(ConsumerRecord<String, byte[]> record) {
        Header[] headers = record.headers().toArray();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(headers.length);
        for (Header header : headers) {
            String key = header.key();
            if (key.equals("targetTopic")) {
                resultMap.put("targetTopic", new String(header.value()));
                continue;
            }
            if (key.equals("startDeliverTime")) {
                resultMap.put("startDeliverTime", header.value());
                continue;
            }
            if (!key.equals("retryTimes")) continue;
            resultMap.put("retryTimes", header.value());
        }
        return resultMap;
    }

    public void stop() {
        this.isRunning = false;
        this.consumer.close();
    }
}

