/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.kafka.KafkaDelayConsumer;
import kd.bos.mq.kafka.KafkaDispatchProducer;
import kd.bos.mq.kafka.KafkaMQTopicUtil;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class KafkaDelayManager {
    private static final Log LOGGER = LogFactory.getLog(KafkaDelayManager.class);
    private static Map<String, List<MetaTime>> LEVEL_DELAYTOPICS_MAP = new HashMap<String, List<MetaTime>>(2);
    public static String DELAYTOPIC_LEVEL_LOW = "low";
    public static String DELAYTOPIC_LEVEL_HIGH = "high";
    private static volatile boolean isStart;

    static void start() {
        if (isStart) {
            return;
        }
        List<String> delayTopicList = KafkaDelayManager.getDelayTopicList();
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)"mq.server");
        for (String tempTopic : delayTopicList) {
            KafkaMQTopicUtil.createTopic(kafkaInfo, tempTopic, 1);
        }
        CountDownLatch countDownLatch = new CountDownLatch(LEVEL_DELAYTOPICS_MAP.size());
        KafkaDelayManager.initDelayConsumer(DELAYTOPIC_LEVEL_LOW, countDownLatch);
        KafkaDelayManager.initDelayConsumer(DELAYTOPIC_LEVEL_HIGH, countDownLatch);
        try {
            boolean isAwait = countDownLatch.await(30L, TimeUnit.SECONDS);
            if (isAwait) {
                LOGGER.info("kafkaDelayConsumer start success in 30 seconds");
            } else {
                LOGGER.info("kafkaDelayConsumer start finish more than 30 seconds");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("countDownLatch InterruptedException");
        }
        isStart = true;
    }

    private static void initDelayConsumer(String delayLevel, CountDownLatch countDownLatch) {
        String delayThreadName = "kafkaDelayConsumer-" + delayLevel;
        List<MetaTime> metaTimeList = LEVEL_DELAYTOPICS_MAP.get(delayLevel);
        KafkaDelayConsumer kafkaDelayConsumer = new KafkaDelayConsumer(delayLevel, metaTimeList, delayThreadName, countDownLatch);
        new Thread(() -> kafkaDelayConsumer.start(), delayThreadName).start();
    }

    public static Future<RecordMetadata> dispatchMessage(ProducerRecord<String, byte[]> messageRecord) {
        return KafkaDispatchProducer.send(messageRecord);
    }

    private static List<String> getDelayTopicList() {
        int[] supportMetaTimes = DelayControlManager.supportMetaTime;
        ArrayList<String> delayTopicList = new ArrayList<String>(supportMetaTimes.length);
        for (int i = 0; i < supportMetaTimes.length; ++i) {
            List<MetaTime> levelTopicList;
            MetaTime metaTime = MetaTime.genInstanceByLevel(i + 1);
            String name = metaTime.getName();
            String topicName = KafkaDelayManager.getDelayTopicName(name);
            delayTopicList.add(topicName);
            String level = DELAYTOPIC_LEVEL_LOW;
            if (i + 1 <= 9) {
                levelTopicList = LEVEL_DELAYTOPICS_MAP.get(level);
            } else {
                level = DELAYTOPIC_LEVEL_HIGH;
                levelTopicList = LEVEL_DELAYTOPICS_MAP.get(level);
            }
            if (levelTopicList == null) {
                levelTopicList = new ArrayList<MetaTime>();
                LEVEL_DELAYTOPICS_MAP.put(level, levelTopicList);
            }
            levelTopicList.add(metaTime);
        }
        return delayTopicList;
    }

    private static String getDelayTopicName(String vhost, String metaTimeName) {
        return vhost + "_" + metaTimeName + "_bos";
    }

    public static String getDelayTopicName(String metaTimeName) {
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)"mq.server");
        return KafkaDelayManager.getDelayTopicName(kafkaInfo.getVhost(), metaTimeName);
    }
}

