/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.kafka.KafkaInfo;
import kd.bos.kafka.KafkamqFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.kafka.KafkaConsumer;
import kd.bos.mq.kafka.KafkaDelayManager;
import kd.bos.mq.kafka.KafkaMQTopicUtil;
import kd.bos.mq.kafka.ProducerFactory;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;

public class KafkaQueueDeclare
implements QueueDeclare {
    private static final Log LOGGER = LogFactory.getLog(KafkaQueueDeclare.class);

    @Override
    public void queueDeclare(String region, String queueRealName, boolean isDuration, Map<String, Object> args) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        KafkaInfo kafkaInfo = KafkamqFactory.getKafkaInfo((String)serverKey);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        String topic = ProducerFactory.getTopicAndGroupName(kafkaInfo.getVhost(), queueRealName);
        int numPartitions = Integer.parseInt(System.getProperty("mq.kafka.topic.partitions", "4"));
        if (def.isSequential()) {
            numPartitions = 1;
        }
        KafkaMQTopicUtil.createTopic(kafkaInfo, topic, numPartitions);
        LOGGER.info("create topic success!,topic=" + topic);
    }

    @Override
    public KafkaConsumer getConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef, MessageConsumer mc) {
        int concurrency = QueueManager.getConcurrency(consumerDef);
        KafkaConsumer consumer = new KafkaConsumer(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength());
        return consumer;
    }

    static {
        String mqServer = System.getProperty("mq.server");
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(mqServer));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (properties.containsKey("type") && properties.getProperty("type").equals("kafka") && !ConfigForInitConsumer.isNotInitConsumer()) {
            Elector elector = ElectFactory.getElector((String)"KafkaDelayManagerElect");
            elector.registerListener(new ElectorListener(){

                public void notifyMaster() {
                    KafkaDelayManager.start();
                }

                public void notifyLostMaster() {
                }
            });
            elector.start();
        }
    }
}

