/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.kafka;

import java.time.Duration;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.kafka.ClassCastUtil;
import kd.bos.mq.kafka.KafkaAcker;
import kd.bos.mq.kafka.KafkaConsumer;
import kd.bos.mq.kafka.KafkaConsumerWorkerPool;
import kd.bos.mq.kafka.KafkaDelayManager;
import kd.bos.mq.kafka.KafkaDispatchProducer;
import kd.bos.mq.kafka.KafkaTopicManager;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.support.ConsumerManager;
import kd.bos.mq.support.QueueManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;

class PollThread
extends Thread {
    private static final Log LOGGER = LogFactory.getLog(PollThread.class);
    private ReentrantLock syncLock;
    private String region;
    private String appId;
    private CopyOnWriteArraySet<String> topicSet;
    private int topicSize;
    private String groupId;
    private Map<String, Semaphore> TOPIC_SEMAPHORE_MAP = new HashMap<String, Semaphore>();
    private org.apache.kafka.clients.consumer.KafkaConsumer<String, byte[]> consumer;
    private ArrayBlockingQueue<ConsumerRecord<String, byte[]>> recordQueue = new ArrayBlockingQueue(1000);
    private ArrayBlockingQueue<Map<TopicPartition, OffsetAndMetadata>> offsetQueue = new ArrayBlockingQueue(10000);

    public PollThread(String threadName, String region, String appId, org.apache.kafka.clients.consumer.KafkaConsumer<String, byte[]> consumer, ReentrantLock reentrantLock) {
        this.setName(threadName);
        this.region = region;
        this.appId = appId;
        this.consumer = consumer;
        this.groupId = consumer.groupMetadata().groupId();
        this.topicSet = KafkaTopicManager.getTopicSet(appId);
        this.topicSize = this.topicSet.size();
        this.syncLock = reentrantLock;
    }

    @Override
    public void run() {
        this.syncSubscribe(this.topicSet);
        this.pollAndHandleMessage();
        this.consumer.close();
    }

    private void pollAndHandleMessage() {
        while (this.topicSize > 0) {
            String topic = "";
            try {
                int maxRetryTimes = Integer.parseInt(System.getProperty("mq.kafka.consumer.retry.times", "16"));
                while (this.recordQueue.size() > 0) {
                    try {
                        this.handleMemoryQueueFirst(maxRetryTimes);
                    }
                    catch (InterruptedException e) {
                        ExceptionLogger.log("memoryQueue take InterruptedException", e);
                    }
                }
                if (this.topicSize != KafkaTopicManager.getTopicSet(this.appId).size() && this.handleTopicsChanged()) break;
                ConsumerRecords<String, byte[]> consumerRecords = this.syncPoll();
                if (consumerRecords.isEmpty()) continue;
                for (ConsumerRecord record : consumerRecords) {
                    topic = record.topic();
                    String region = KafkaTopicManager.getRegionByTopic(topic);
                    String realQueueName = KafkaTopicManager.getQueueByTopic(topic);
                    boolean hasKafkaConsumer = QueueManager.getConsumers().containsKey(realQueueName);
                    if (!hasKafkaConsumer) {
                        LOGGER.info("kafkaConsumer not find in QueueManager,appId={},topic={},region={},queue={}", new Object[]{this.appId, topic, region, realQueueName});
                        try {
                            ProducerRecord<String, byte[]> newProducerRecord = this.copyRecord((ConsumerRecord<String, byte[]>)record);
                            KafkaDispatchProducer.send(newProducerRecord).get();
                            LOGGER.info("send message back success,appId={},topic={},region={},queue={}", new Object[]{this.appId, record.topic(), region, realQueueName});
                            KafkaTopicManager.removeTopic(this.appId, topic);
                            LOGGER.info("KafkaTopicManager.removeTopic,appId={},topic={}", (Object)this.appId, (Object)topic);
                            this.commitOffset((ConsumerRecord<String, byte[]>)record);
                        }
                        catch (Exception ex) {
                            LOGGER.error("kafkaConsumer not find in QueueManager,hander error,appId={},topic={},region={},queue={}", new Object[]{this.appId, topic, region, realQueueName});
                        }
                        continue;
                    }
                    Semaphore semaphore = this.TOPIC_SEMAPHORE_MAP.get(topic);
                    if (semaphore == null) {
                        semaphore = new Semaphore(2);
                        this.TOPIC_SEMAPHORE_MAP.put(topic, semaphore);
                    }
                    try {
                        boolean offerFlag;
                        boolean flag = semaphore.tryAcquire(10L, TimeUnit.MILLISECONDS);
                        if (!flag && (offerFlag = this.recordQueue.offer((ConsumerRecord<String, byte[]>)record, 1000L, TimeUnit.MILLISECONDS))) {
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        ExceptionLogger.log("semaphore InterruptedException", e);
                    }
                    Semaphore finalSemaphore = semaphore;
                    KafkaConsumerWorkerPool.execute(() -> {
                        try {
                            KafkaAcker acker = new KafkaAcker();
                            int retryTimes = this.getHeaderRetryTimes((ConsumerRecord<String, byte[]>)record);
                            this.handleDelivery((ConsumerRecord<String, byte[]>)record, acker, retryTimes);
                            if (acker.isDenied() && ++retryTimes < maxRetryTimes) {
                                this.dispatchToDelayTopic((ConsumerRecord<String, byte[]>)record, retryTimes);
                            }
                        }
                        catch (Exception ex) {
                            ExceptionLogger.log("kafkaWorker handleDelivery topic=" + record.topic() + " error", ex);
                        }
                        finally {
                            this.commitOffset((ConsumerRecord<String, byte[]>)record);
                            finalSemaphore.release();
                        }
                    });
                }
            }
            catch (Exception e) {
                ExceptionLogger.log(Thread.currentThread().getName() + " pollAndHandleMessage topic=" + topic + " error", e);
            }
        }
    }

    private ProducerRecord<String, byte[]> copyRecord(ConsumerRecord<String, byte[]> oldRecord) {
        ProducerRecord producerRecord = new ProducerRecord(oldRecord.topic(), oldRecord.value());
        Header[] oldHeaders = oldRecord.headers().toArray();
        if (oldHeaders.length > 0) {
            for (Header tempHeader : oldHeaders) {
                producerRecord.headers().add(tempHeader.key(), tempHeader.value());
            }
        }
        return producerRecord;
    }

    private void dispatchToDelayTopic(ConsumerRecord<String, byte[]> record, int retryTimes) throws ExecutionException, InterruptedException {
        MetaTime metaTime = MetaTime.genInstanceByLevel(retryTimes + 2);
        if (metaTime == null) {
            return;
        }
        String delayTopic = KafkaDelayManager.getDelayTopicName(metaTime.getName());
        ProducerRecord dispatchRecord = new ProducerRecord(delayTopic, record.value());
        dispatchRecord.headers().add("targetTopic", record.topic().getBytes());
        Calendar calendar = Calendar.getInstance();
        calendar.add(14, metaTime.getMillis());
        dispatchRecord.headers().add("startDeliverTime", ClassCastUtil.longToBytes(calendar.getTime().getTime()));
        dispatchRecord.headers().add("retryTimes", ClassCastUtil.int2bytes(retryTimes));
        KafkaDispatchProducer.send((ProducerRecord<String, byte[]>)dispatchRecord).get();
    }

    private void commitOffset(ConsumerRecord<String, byte[]> record) {
        HashMap<TopicPartition, OffsetAndMetadata> partitionOffSetMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        partitionOffSetMap.put(new TopicPartition(record.topic(), record.partition()), new OffsetAndMetadata(record.offset() + 1L));
        boolean offerFlag = this.offsetQueue.offer(partitionOffSetMap);
        if (!offerFlag) {
            this.syncCommit(partitionOffSetMap);
        }
    }

    private boolean handleTopicsChanged() {
        this.topicSet = KafkaTopicManager.getTopicSet(this.appId);
        if (this.topicSet == null || this.topicSet.size() == 0) {
            return true;
        }
        this.topicSize = this.topicSet.size();
        for (String tempTopic : this.topicSet) {
            if (this.TOPIC_SEMAPHORE_MAP.containsKey(tempTopic)) continue;
            String queue = KafkaTopicManager.getQueueByTopic(tempTopic);
            QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(null, queue);
            int concurrency = queueDef.getConsumers().get(0).getConcurrency();
            Semaphore semaphore = new Semaphore(concurrency);
            this.TOPIC_SEMAPHORE_MAP.put(tempTopic, semaphore);
        }
        this.syncSubscribe(this.topicSet);
        return false;
    }

    private void handleMemoryQueueFirst(int maxRetryTimes) throws InterruptedException {
        ConsumerRecord<String, byte[]> record = this.recordQueue.take();
        KafkaConsumerWorkerPool.execute(() -> {
            KafkaAcker acker = new KafkaAcker();
            int retryTimes = this.getHeaderRetryTimes(record);
            try {
                this.handleDelivery(record, acker, retryTimes);
                if (acker.isDenied() && ++retryTimes < maxRetryTimes) {
                    this.dispatchToDelayTopic(record, retryTimes);
                }
            }
            catch (Exception ex) {
                ExceptionLogger.log("kafkaWorker handleMemoryQueueFirst topic=" + record.topic() + " error", ex);
            }
            finally {
                this.commitOffset(record);
            }
        });
    }

    private void handleDelivery(ConsumerRecord<String, byte[]> record, KafkaAcker acker, int reconsumeTimes) {
        String topic = record.topic();
        String messageId = topic + "_" + record.partition() + "_" + record.offset();
        String realQueueName = KafkaTopicManager.getQueueByTopic(topic);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)QueueManager.getConsumers().get(realQueueName);
        ConsumerManager.innerHandleDelivery(acker, kafkaConsumer.getMessageConsumer(), kafkaConsumer.getRegion(), kafkaConsumer.getQueueName(), messageId, reconsumeTimes, (byte[])record.value(), topic);
    }

    private int getHeaderRetryTimes(ConsumerRecord<String, byte[]> record) {
        int retryTimes = 0;
        Map<String, Object> recordHeaderMap = this.getRecordHeaderMap(record);
        if (recordHeaderMap.containsKey("retryTimes")) {
            retryTimes = ClassCastUtil.bytes2Int((byte[])recordHeaderMap.get("retryTimes"));
        }
        return retryTimes;
    }

    private Map<String, Object> getRecordHeaderMap(ConsumerRecord<String, byte[]> record) {
        Header[] headers = record.headers().toArray();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(headers.length);
        for (Header header : headers) {
            String key = header.key();
            if (key.equals("targetTopic")) {
                resultMap.put("targetTopic", new String(header.value()));
                continue;
            }
            if (key.equals("startDeliverTime")) {
                resultMap.put("startDeliverTime", header.value());
                continue;
            }
            if (!key.equals("retryTimes")) continue;
            resultMap.put("retryTimes", header.value());
        }
        return resultMap;
    }

    private ConsumerRecords<String, byte[]> syncPoll() {
        try {
            this.syncLock.lock();
            ConsumerRecords consumerRecords = this.consumer.poll(Duration.ofMillis(100L));
            return consumerRecords;
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void syncSubscribe(Collection<String> topics) {
        try {
            this.syncLock.lock();
            HashSet<String> currTopicSet = new HashSet<String>(topics);
            this.consumer.subscribe(currTopicSet);
        }
        finally {
            this.syncLock.unlock();
        }
    }

    private void syncCommit(Map<TopicPartition, OffsetAndMetadata> offsetMap) {
        try {
            this.syncLock.lock();
            this.consumer.commitSync(offsetMap);
        }
        finally {
            this.syncLock.unlock();
        }
    }

    public Set<String> getTopicSet() {
        return this.topicSet;
    }

    public Map<TopicPartition, OffsetAndMetadata> pollOffset() {
        try {
            return this.offsetQueue.poll(10L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ExceptionLogger.log("memoryQueue poll InterruptedException", e);
            return null;
        }
    }
}

