/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.metric.Gauger;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.support.AckedCallBack;
import kd.bos.mq.support.MessageCommonAcker;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.MessageTable;

public class PigeonAcker
implements MessageCommonAcker {
    private static final AtomicInteger ackMessageSize = new AtomicInteger(0);
    private IStoreDbConfig storeDbConfig;
    private String messageTable;
    private long id;
    private String messageId;
    private byte[] msgData;
    private Integer reconsumeTime;
    private AckedCallBack ackedCallback;
    private int visitStatus = 0;
    private int ackStatus = 0;

    public PigeonAcker(IStoreDbConfig storeDbConfig, String messageTable, long id, String messageId, int reconsumeTime) {
        this.storeDbConfig = storeDbConfig;
        this.messageTable = messageTable;
        this.id = id;
        this.messageId = messageId;
        this.reconsumeTime = reconsumeTime;
    }

    public int getAckStatus() {
        return this.ackStatus;
    }

    public void setAckStatus(int ackStatus) {
        this.ackStatus = ackStatus;
    }

    @Override
    public boolean hasDone() {
        return this.visitStatus > 0;
    }

    @Override
    public synchronized void ack(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(1);
        this.update(MessageStatus.SUCCESS.getDesc());
        if (this.ackedCallback != null) {
            this.ackedCallback.call();
        }
        ackMessageSize.incrementAndGet();
    }

    @Override
    public synchronized void deny(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        Integer n = this.reconsumeTime;
        Integer n2 = this.reconsumeTime = Integer.valueOf(this.reconsumeTime + 1);
        if (this.reconsumeTime > DelayControlManager.supportMetaTime.length) {
            this.setAckStatus(3);
            this.update(MessageStatus.FAILED.getDesc());
            return;
        }
        this.setAckStatus(2);
        this.update(MessageStatus.RETRY.getDesc(), this.reconsumeTime);
    }

    @Override
    public synchronized void discard(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(3);
        this.update(MessageStatus.DISCARD.getDesc());
    }

    private void update(String status) {
        this.doUpdate(status, -1);
    }

    private void update(String status, Integer reconsumeTime) {
        this.doUpdate(status, reconsumeTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(String status, Integer reconsumeTime) {
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        RequestTimeoutContext.set(null);
        try (TXHandle handle = TX.requiresNew((String)"PIGEON_CONSUMER_ACK");){
            if (this.messageTable.equals(MessageTable.GENERAL.getDesc())) {
                if (reconsumeTime < 0) {
                    QueueMessageEntityHelper.update((IStoreDbConfig)this.storeDbConfig, (long)this.id, (String)status);
                } else {
                    QueueMessageEntityHelper.update((IStoreDbConfig)this.storeDbConfig, (long)this.id, (String)status, (Integer)reconsumeTime, (Date)this.convertDelayDateTime(reconsumeTime));
                }
            } else if (this.messageTable.equals(MessageTable.BIG.getDesc())) {
                // empty if block
            }
        }
        finally {
            RequestTimeoutContext.set((RequestTimeoutContext)requestTimeoutContext);
        }
    }

    private Date convertDelayDateTime(int reconsumeTime) {
        int delaySecond = DelayControlManager.supportMetaTime[reconsumeTime - 1];
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, delaySecond);
        return calendar.getTime();
    }

    @Override
    public boolean isDenied() {
        return this.ackStatus == 2;
    }

    @Override
    public void setAckedCallBack(AckedCallBack ackedCallback) {
        this.ackedCallback = ackedCallback;
    }

    @Override
    public boolean isAcked() {
        return this.ackStatus == 1;
    }

    @Override
    public boolean isDiscarded() {
        return this.ackStatus == 3;
    }

    public byte[] getMsgData() {
        return this.msgData;
    }

    public void setMsgData(byte[] msgData) {
        this.msgData = msgData;
    }

    static {
        MetricSystem.gauge((String)"kd.metrics.mq.pigeon.ack.message.size", () -> {
            Gauger metricsObj = new Gauger();
            metricsObj.setValueSupplier(() -> ackMessageSize.getAndSet(0));
            return metricsObj;
        });
    }
}

