/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.Date;
import java.util.ServiceLoader;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.mq.pigeon.PigeonConsumerService;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueManager;

public class PigeonConsumer
implements Consumer {
    private String region;
    private String queueName;
    private boolean autoAck;
    private int concurrency;
    private MessageConsumer mc;
    private volatile boolean isStartedFlag;
    private Date startAt;

    public PigeonConsumer(String region, String queueName, boolean autoAck, int concurrency, MessageConsumer mc) {
        this.region = region;
        this.queueName = queueName;
        this.autoAck = autoAck;
        this.concurrency = concurrency;
        this.mc = mc;
        PigeonConsumerManager.getConsumerounter().inc();
    }

    @Override
    public void start() {
        this.isStartedFlag = true;
        this.startAt = new Date();
        PigeonConsumerManager.registConcurrency(this.queueName, this.concurrency);
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(this.region, this.queueName);
        for (PigeonConsumerService tempConsumerService : ServiceLoader.load(PigeonConsumerService.class)) {
            tempConsumerService.start(this.region, queueDef, this.queueName, this.concurrency, this.mc);
        }
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.mc;
    }

    @Override
    public void $$stop() {
        this.isStartedFlag = false;
        PigeonConsumerManager.removeConcurrency(this.queueName);
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(this.region, this.queueName);
        for (PigeonConsumerService tempConsumerService : ServiceLoader.load(PigeonConsumerService.class)) {
            tempConsumerService.stop(this.region, queueDef, this.queueName, this.concurrency, this.mc);
        }
    }

    @Override
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public boolean isStarted() {
        return this.isStartedFlag;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }
}

