/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMesPubFactory;
import kd.bos.mq.dlx.DLXStrategy;
import kd.bos.mq.dlx.MessageRecord;
import kd.bos.mq.pigeon.PigeonAcker;
import kd.bos.mq.pigeon.PigeonPublisher;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageCommonAcker;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.TimeCacheMap;
import kd.bos.mq.support.TranscationSupport;
import kd.bos.pigeon.core.data.PigeonMessageDTO;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.entity.QueueMessageEntity;
import kd.bos.pigeon.core.store.db.helper.QueueMessageEntityHelper;
import kd.bos.pigeon.core.support.MessageStatus;
import kd.bos.pigeon.core.support.MessageTable;
import kd.bos.thread.SetThreadName;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;

public class PigeonConsumerManager {
    private static final Log LOGGER = LogFactory.getLog(PigeonConsumerManager.class);
    private static final Counter noRequestContextCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.noRequestContextCounter");
    private static final Counter decodeMessageErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.decodeMessageErrorCounter");
    private static final Counter handlerMessagerErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerOnMessagerErrorCounter");
    private static final Counter handlerMessagerTranscationRollBackCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRollBackCounter");
    private static final Counter handlerMessagerTranscationRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRepeateCounter");
    private static final Counter handlerMessagerRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerRepeateCounter");
    private static final Counter consumerounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.Counter");
    private static final Counter activeCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.activeConsumers");
    private static final TimeCacheMap<AtomicInteger> messageRepeatTimes = new TimeCacheMap(300);
    private static final Map<String, AtomicInteger> queueName2defconcurrencyMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<String, AtomicInteger> queueName2concurrencyMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<String, AtomicInteger> queueName2waitingMap = new ConcurrentHashMap<String, AtomicInteger>();
    public static final String[] consumerProcessStatusArray = new String[]{MessageStatus.RECEIVED.getDesc(), MessageStatus.RUNNING.getDesc()};

    static Counter getConsumerounter() {
        return consumerounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void innerHandleDelivery(String bizType, String queue, PigeonMessageDTO pigeonMessageDTO) {
        Message message;
        IStoreDbConfig storeDbConfig = StoreDbConfigFactory.getDbConfigByBizType((String)bizType);
        String messageTable = pigeonMessageDTO.getMessageTable();
        boolean updateFlag = QueueMessageEntityHelper.update((IStoreDbConfig)storeDbConfig, (long)pigeonMessageDTO.getId(), (String)MessageStatus.RUNNING.getDesc(), (String[])new String[]{MessageStatus.RECEIVED.getDesc()});
        if (!updateFlag) {
            ExceptionLogger.log("MQError:updateMessageStatusError,messageTable=" + messageTable + ",queue=" + queue + ",id=" + pigeonMessageDTO.getId());
            return;
        }
        QueueMessageEntity messageEntity = null;
        if (messageTable.equals(MessageTable.GENERAL.getDesc())) {
            messageEntity = QueueMessageEntityHelper.query((IStoreDbConfig)storeDbConfig, (long)pigeonMessageDTO.getId());
        }
        if (messageEntity == null) {
            ExceptionLogger.log("MQError:queryError,messageTable=" + messageTable + ",queue=" + queue + ",id=" + pigeonMessageDTO.getId());
            return;
        }
        String region = messageEntity.getRegion();
        String messageId = String.valueOf(pigeonMessageDTO.getId());
        int reConsumeTime = messageEntity.getReConsumeTime();
        PigeonAcker acker = new PigeonAcker(storeDbConfig, messageTable, pigeonMessageDTO.getId(), messageId, reConsumeTime);
        try {
            message = PigeonConsumerManager.toMessage(messageEntity.getMsgData());
        }
        catch (Exception e) {
            acker.discard(messageId);
            decodeMessageErrorCounter.inc();
            ExceptionLogger.log("MQError:toMessage exception, auto discard, messageId=" + messageId + ",queue:" + queue, e);
            return;
        }
        if (PigeonConsumerManager.renewDelay(messageId, message, acker, region, queue)) {
            return;
        }
        Consumer consumer = (Consumer)QueueManager.getConsumers().get(queue);
        MessageConsumer messageConsumer = consumer.getMessageConsumer();
        if (StringUtils.isNotEmpty((String)message.getKdtxId())) {
            PigeonConsumerManager._handleDtxDelivery(region, queue, message, messageId, reConsumeTime, messageConsumer, acker);
            return;
        }
        long messageInnerId = message.getInnerId();
        if (messageInnerId != 0L) {
            AtomicInteger ai = messageRepeatTimes.get(messageInnerId);
            if (ai == null) {
                ai = new AtomicInteger(0);
                messageRepeatTimes.put(messageInnerId, ai);
            }
            if (ai.getAndIncrement() > 100) {
                acker.discard(messageId);
                messageRepeatTimes.remove(messageInnerId);
                handlerMessagerRepeateCounter.inc();
                ExceptionLogger.log("MQError:Repeat send message too many times, auto discard, messageId=" + messageId + ",queue=" + queue);
                return;
            }
        }
        try {
            PigeonConsumerManager._handleDelivery(region, queue, message, messageId, reConsumeTime, messageConsumer, acker);
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                int tryTimes = TranscationSupport.instance().tryTimes(String.valueOf(message.getInnerId()));
                if (tryTimes > 30) {
                    acker.discard(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception,try times >30, auto discard, messageId=" + messageId, t);
                } else {
                    PigeonConsumerManager.applyWait(tryTimes);
                    acker.deny(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
                }
            } else {
                ExceptionLogger.log("MQError:handleDelivery uncatched exception, messageId=" + messageId, t);
            }
        }
        finally {
            if (!acker.isDenied()) {
                messageRepeatTimes.remove(messageInnerId);
            }
        }
    }

    private static boolean renewDelay(String messageId, Message message, MessageCommonAcker acker, String region, String queue) {
        int remainSeconds = (int)((message.getStartDeliverTime() - System.currentTimeMillis()) / 1000L);
        if (message.getStartDeliverTime() > 0L && remainSeconds > 0) {
            try {
                byte[] bytes = MessageSerde.get().encode(message);
                new PigeonPublisher(region, queue, PigeonmqFactory.getVhost()).publishDelay(bytes, remainSeconds);
                acker.discard(messageId);
            }
            catch (Exception e) {
                acker.deny(messageId);
                ExceptionLogger.log("renew delay for queue " + queue + " error ", e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _handleDtxDelivery(String region, String queue, Message message, String messageId, int reConsumeTime, MessageConsumer messageConsumer, MessageCommonAcker acker) {
        boolean isManual = false;
        boolean dbTransEnd = true;
        DBRoute dbRoute = DBRoute.of((String)message.getRouteKey());
        boolean isResend = reConsumeTime > 0;
        try {
            boolean b = PigeonConsumerManager.createTraceAndRequestContext(message);
            if (!b) {
                acker.discard(messageId);
                KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
                noRequestContextCounter.inc();
                return;
            }
            boolean isReceived = KdtxSupport.isReceived(dbRoute, message.getKdtxId(), message.getSeq());
            if (!isReceived) {
                try {
                    KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                }
                catch (Exception e) {
                    acker.deny(messageId);
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "MQError:message update receive statue error, will requeue", true);
                    noRequestContextCounter.inc();
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
                    if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                        if (isManual) {
                            KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                        }
                        KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
                    }
                    return;
                }
            } else if (!isResend) {
                isManual = KdtxSupport.isManual(message.getKdtxId(), message.getSeq());
                if (!isManual) {
                    acker.discard(messageId);
                    return;
                }
            } else if (KdtxSupport.mqSecondCompensate(message.getKdtxId(), message.getSeq())) {
                acker.discard(messageId);
                return;
            }
            if (message.getKdtxId().equals(message.getTranscationTag())) {
                if (TranscationSupport.instance().isRollBack(message.getTranscationTag())) {
                    acker.isDiscarded();
                    return;
                }
                if (!TranscationSupport.instance().existXid(message.getRouteKey(), message.getTranscationTag())) {
                    acker.isDiscarded();
                    dbTransEnd = false;
                    return;
                }
            }
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), String.format("message[isReceived:%s,isManual:%s] start execute", isReceived, isManual), false);
            RequestContext rc = RequestContext.get();
            if (PigeonConsumerManager.isforbiddenTenantCode(rc.getTenantCode())) {
                LockSupport.parkNanos(1000000000L);
                acker.deny(messageId);
                return;
            }
            if (DLXConfig.isSendDLX(message.getRequestContext())) {
                message.setDLXMessage(true);
                DLXMesPubFactory.getDLXMessagePublisher().sendMessage(region, queue, message, messageId, acker);
                return;
            }
            PigeonConsumerManager.doTraceAndConsume(region, queue, message, messageId, isResend, messageConsumer, acker);
            if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
                MessageRecord.update(2, message.getInnerId());
            }
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                PigeonConsumerManager.applyWait(1);
                acker.deny(messageId);
                KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "common exception auto deny,errorMsg:" + t.getMessage(), true);
            }
            ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
        }
        finally {
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
            if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                if (isManual) {
                    KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                }
                KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
            }
        }
    }

    public static void _handleDelivery(String region, String queue, Message message, String messageId, int reConsumeTime, MessageConsumer messageConsumer, MessageCommonAcker acker) {
        boolean b = PigeonConsumerManager.createTraceAndRequestContext(message);
        if (!b) {
            acker.discard(messageId);
            ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
            noRequestContextCounter.inc();
            return;
        }
        RequestContext rc = RequestContext.get();
        if (PigeonConsumerManager.isforbiddenTenantCode(rc.getTenantCode())) {
            LockSupport.parkNanos(1000000000L);
            acker.deny(messageId);
            return;
        }
        if (DLXConfig.isSendDLX(message.getRequestContext())) {
            message.setDLXMessage(true);
            DLXMesPubFactory.getDLXMessagePublisher().sendMessage(region, queue, message, messageId, acker);
            return;
        }
        if (!PigeonConsumerManager.isTransactionSubmit(message, messageId, messageConsumer, acker)) {
            return;
        }
        boolean isResend = reConsumeTime > 0;
        PigeonConsumerManager.doTraceAndConsume(region, queue, message, messageId, isResend, messageConsumer, acker);
        if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
            MessageRecord.update(2, message.getInnerId());
        }
    }

    private static boolean isTransactionSubmit(Message message, String messageId, MessageConsumer messageConsumer, MessageCommonAcker acker) {
        String xid = message.getTranscationTag();
        if (xid != null) {
            boolean existXid;
            int loop = -1;
            int max = 3;
            boolean isMessageTimeout = PigeonConsumerManager.isMessageTimeout(message);
            do {
                if (TranscationSupport.instance().isRollBack(xid)) {
                    acker.discard(messageId);
                    handlerMessagerTranscationRollBackCounter.inc();
                    return false;
                }
                existXid = TranscationSupport.instance().existXid(message.getRouteKey(), xid);
                if (max == ++loop || isMessageTimeout) break;
                PigeonConsumerManager.applyWait(loop);
            } while (!existXid);
            if (!existXid) {
                PigeonConsumerManager.waitDeal(messageId, message, acker, xid);
                return false;
            }
            String messageRouteKey = message.getRouteKey();
            String consumeRouteKey = messageConsumer.getRouteKey();
            if (consumeRouteKey == null) {
                consumeRouteKey = messageRouteKey;
            }
            if (TranscationSupport.instance().existConsumedId(consumeRouteKey, xid)) {
                acker.discard(messageId);
                handlerMessagerTranscationRepeateCounter.inc();
                return false;
            }
            String _consumeRouteKey = consumeRouteKey;
            acker.setAckedCallBack(() -> {
                try {
                    TranscationSupport.instance().insertConsumed(_consumeRouteKey, xid);
                    TranscationSupport.instance().deleteXid(messageRouteKey, xid);
                }
                catch (Exception e) {
                    ExceptionLogger.log("mq TranscationSupport error of acktion" + messageId, e);
                }
            });
        }
        return true;
    }

    private static void waitDeal(String messageId, Message message, MessageCommonAcker acker, String xid) {
        if (message.getRetryTimes() != -1) {
            PigeonConsumerManager.delayStrategy(messageId, message, acker);
        } else {
            PigeonConsumerManager.timesStrategy(messageId, message, acker, xid);
        }
    }

    private static void delayStrategy(String messageId, Message message, MessageCommonAcker acker) {
        int retryTimes = message.getRetryTimes();
        if (retryTimes >= 14) {
            acker.discard(messageId);
        } else {
            acker.deny(messageId);
        }
    }

    private static void timesStrategy(String messageId, Message message, MessageCommonAcker acker, String xid) {
        int tryTimes = TranscationSupport.instance().tryTimes(xid);
        if (tryTimes > 30 || PigeonConsumerManager.isMessageTimeout(message)) {
            acker.discard(messageId);
            handlerMessagerTranscationRollBackCounter.inc();
        } else {
            PigeonConsumerManager.applyWait(tryTimes);
            acker.deny(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doTraceAndConsume(String region, String queue, Message message, String messageId, boolean resend, MessageConsumer messageConsumer, MessageCommonAcker acker) {
        try (TraceSpan span = Tracer.create((String)"MQConsumer", (String)"onMessage", (boolean)true);){
            span.addTag("messageId", messageId);
            span.addTag("resent", Boolean.toString(resend));
            span.addTag("queue", queue);
            span.addTag("region", region);
            try {
                activeCounter.inc();
                ConsumerStats.incrementActiveCount(queue, messageId);
                messageConsumer.onMessage(message.getBody(), messageId, resend, acker);
                if (!acker.hasDone()) {
                    acker.ack(messageId);
                }
            }
            catch (Exception t) {
                if (!acker.hasDone()) {
                    handlerMessagerErrorCounter.inc();
                    ExceptionLogger.log("MQError:onMessage uncatched exception, auto discard, messageId=" + messageId, t);
                    acker.discard(messageId);
                } else {
                    ExceptionLogger.log("MQError:onMessage uncatched exception, messageId=" + messageId, t);
                }
            }
            finally {
                activeCounter.dec();
                ConsumerStats.decrementActiveCount(queue, messageId);
            }
        }
    }

    private static boolean isMessageTimeout(Message message) {
        long timeout = (long)Integer.parseInt(System.getProperty("mq.trasncation.message.waittime", "300")) * 1000L;
        return System.currentTimeMillis() - message.getMessageTime() > timeout;
    }

    private static boolean createTraceAndRequestContext(Message message) {
        RequestContext rc = message.getRequestContext();
        if (rc == null) {
            return false;
        }
        String traceId = TraceIdUtil.createTraceIdString();
        SetThreadName.setTraceId((String)traceId);
        rc.setTraceId(traceId);
        RequestContextCreator.restoreForMQ((RequestContext)rc);
        return true;
    }

    private static void applyWait(int tryTimes) {
        if (tryTimes < 1) {
            return;
        }
        if (tryTimes == 1) {
            LockSupport.parkNanos(100000000L);
        } else {
            LockSupport.parkNanos(1000000000L * (long)tryTimes);
        }
    }

    private static Message toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    private static boolean isforbiddenTenantCode(String tenantCode) {
        if (Instance.isPausedServiceByMonitor()) {
            return true;
        }
        String fbStr = System.getProperty("mq.consume.forbidden.tenantcodes");
        if (fbStr == null) {
            return false;
        }
        String[] fbTenantCodes = fbStr.split(",|;");
        if (fbTenantCodes == null) {
            return false;
        }
        for (String fbcode : fbTenantCodes) {
            if (!tenantCode.equalsIgnoreCase(fbcode)) continue;
            return true;
        }
        return false;
    }

    public static void registConcurrency(String queueRealName, int concurrency) {
        int val = Math.min(concurrency, 10);
        queueName2defconcurrencyMap.putIfAbsent(queueRealName, new AtomicInteger(val));
        queueName2concurrencyMap.putIfAbsent(queueRealName, new AtomicInteger(val));
        int waitVal = PigeonConsumerManager.getWaitingValue(concurrency);
        queueName2waitingMap.putIfAbsent(queueRealName, new AtomicInteger(val + waitVal));
    }

    public static int getWaitingValue(int concurrency) {
        return Integer.getInteger("mq.pigeon.consumer.concurrency.wait", 5);
    }

    public static Set<String> getQueueNameSet() {
        return queueName2concurrencyMap.keySet();
    }

    public static void removeConcurrency(String queueRealName) {
        LOGGER.info("removeConcurrency,queueRealName:{}", (Object)queueRealName);
        queueName2defconcurrencyMap.remove(queueRealName);
        queueName2concurrencyMap.remove(queueRealName);
        queueName2waitingMap.remove(queueRealName);
    }

    public static AtomicInteger mserviceGetDefConcurrency(String queueRealName) {
        return queueName2defconcurrencyMap.get(queueRealName);
    }

    public static AtomicInteger getConcurrency(String queueRealName) {
        return queueName2concurrencyMap.get(queueRealName);
    }

    public static AtomicInteger getWaiting(String queueRealName) {
        return queueName2waitingMap.get(queueRealName);
    }

    public static String[] getConsumerProcessStatusArray() {
        return consumerProcessStatusArray;
    }
}

