/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.id.ID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.pigeon.PigeonConsumer;
import kd.bos.mq.pigeon.PigeonmqFactory;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;
import kd.bos.pigeon.core.store.db.IStoreDbConfig;
import kd.bos.pigeon.core.store.db.StoreDbConfigFactory;
import kd.bos.pigeon.core.store.db.entity.QueueEntity;
import kd.bos.pigeon.core.store.db.helper.QueueEntityHelper;
import kd.bos.pigeon.core.store.db.helper.QueueTableHelper;

public class PigeonQueueDeclare
implements QueueDeclare {
    private static final Log LOGGER = LogFactory.getLog(PigeonQueueDeclare.class);
    private static final Object LOCKER = new Object();
    private static final ConcurrentHashMap<String, Boolean> queueDeclared = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Boolean> accountId2tableInitMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueDeclare(String region, String queueRealName, boolean isDuration, Map<String, Object> args) {
        if (FailoverConfig.MQ_FAILOVER_ENABLE) {
            return;
        }
        String accountId = RequestContext.get().getAccountId();
        if (accountId2tableInitMap.get(accountId) == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (accountId2tableInitMap.get(accountId) == null) {
                    QueueTableHelper.tableInit();
                    accountId2tableInitMap.put(accountId, Boolean.TRUE);
                }
            }
        }
        if (Boolean.TRUE.equals(queueDeclared.get(accountId + "_" + queueRealName))) {
            return;
        }
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        IStoreDbConfig dbConfig = StoreDbConfigFactory.getDbConfigByRegion((String)region);
        DLock dLock = DLock.create((String)("/dlock/pigeon/queue/insert_" + queueRealName));
        try {
            QueueEntity dbQueueEntity;
            if (!dLock.tryLock()) {
                return;
            }
            QueueEntity queueEntity = new QueueEntity();
            queueEntity.setId(ID.genLongId()).setVhost(PigeonmqFactory.getVhost()).setName(queueDef.getName()).setRealName(queueRealName).setRegion(region).setAppId(queueDef.getAppid()).setSequential(queueDef.isSequential()).setCreateTime(new Date()).setConsumerClass(queueDef.getConsumers().get(0).getClassName()).setConsumerConcurrency(QueueManager.getConcurrency(queueDef.getConsumers().get(0)));
            if (!Instance.isAppSplit() || region.equals("demo")) {
                queueEntity.setAppId("");
            }
            if ((dbQueueEntity = QueueEntityHelper.query((IStoreDbConfig)dbConfig, (String)queueRealName)) == null) {
                try (TXHandle handle = TX.requiresNew((String)"PIGEON_QUEUE_INSERT");){
                    QueueEntityHelper.insert((IStoreDbConfig)dbConfig, (QueueEntity)queueEntity);
                }
            }
            if (!dbQueueEntity.equals(queueEntity)) {
                try (TXHandle handle = TX.requiresNew((String)"PIGEON_QUEUE_UPDATE");){
                    QueueEntityHelper.update((IStoreDbConfig)dbConfig, (QueueEntity)queueEntity);
                }
            }
            queueDeclared.putIfAbsent(accountId + "_" + queueRealName, Boolean.TRUE);
        }
        catch (Exception e) {
            LOGGER.error("QueueEntityHelper insert error", (Throwable)e);
        }
        finally {
            dLock.unlock();
        }
    }

    @Override
    public Consumer getConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef, MessageConsumer mc) {
        return new PigeonConsumer(region, queueName, consumerDef.isAutoAck(), QueueManager.getConcurrency(consumerDef), mc);
    }
}

