/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.pigeon;

import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.pigeon.PigeonInfo;
import kd.bos.util.StringUtils;

public class PigeonmqFactory {
    private static final Log LOGGER = LogFactory.getLog(PigeonmqFactory.class);
    private static final ConcurrentHashMap<String, String> region2mqserverMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, PigeonInfo> pigeonInfoMap = new ConcurrentHashMap();
    private static String vhost;

    public static String getRegionServerKey(String region) {
        if (!FailoverConfig.MQ_FAILOVER_ENABLE) {
            return "mq.server";
        }
        String mqServer = region2mqserverMap.get(region);
        if (mqServer != null) {
            return mqServer;
        }
        String serverInfo = System.getProperty("mq.failover.server");
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (prop.getProperty("type").equals("pigeon")) {
            region2mqserverMap.put(region, "mq.failover.server");
            return "mq.failover.server";
        }
        region2mqserverMap.put(region, "mq.server");
        return "mq.server";
    }

    public static PigeonInfo getPigeonInfo(String serverKey) {
        PigeonInfo pigeonInfo = pigeonInfoMap.get(serverKey);
        if (pigeonInfo != null) {
            return pigeonInfo;
        }
        Class<PigeonmqFactory> clazz = PigeonmqFactory.class;
        synchronized (PigeonmqFactory.class) {
            if (pigeonInfoMap.containsKey(serverKey)) {
                pigeonInfo = pigeonInfoMap.get(serverKey);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return pigeonInfo;
            }
            try {
                pigeonInfo = PigeonmqFactory.createPigeonInfo(serverKey);
                pigeonInfoMap.put(serverKey, pigeonInfo);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return pigeonInfo;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{e.getMessage()});
            }
        }
    }

    private static PigeonInfo createPigeonInfo(String serverKey) {
        String serverInfo = System.getProperty(serverKey);
        if (serverInfo == null) {
            LOGGER.error("pigeon server not config for " + serverKey);
            throw new KDException(BosErrorCode.mqException, new Object[]{"pigeon server not config for " + serverKey});
        }
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            PigeonInfo pigeonInfo = new PigeonInfo();
            String str = Objects.requireNonNull(prop.getProperty("vhost"), "pigeon vhost can't be empty.");
            String queueTag = System.getProperty("mq.debug.queue.tag");
            if (StringUtils.isNotEmpty((String)queueTag)) {
                str = queueTag;
            }
            pigeonInfo.setVhost(str);
            vhost = str;
            return pigeonInfo;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{e.getMessage()});
        }
    }

    public static String getVhost() {
        if (vhost == null) {
            PigeonmqFactory.getPigeonInfo("mq.server");
        }
        return vhost;
    }
}

