/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.broadcast.Broadcast;
import kd.bos.mq.broadcast.BroadcastService;
import kd.bos.mq.broadcast.Configure;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.RabbitBroadcastConsumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.NetAddressUtils;

public class RabbitBroadcast
extends Broadcast {
    protected static final String EXCHANGE_NAME = "exchange_fanout_" + Instance.getClusterName() + System.getProperty("mq.debug.queue.tag", "");
    protected static final String EXCHANGE_REGION = "broadcast";
    protected static final String EXCHANGE_TYPE = "fanout";
    private static final Log logger = LogFactory.getLog(RabbitBroadcast.class);
    private static Channel consumerChannel;
    private static Map<String, Channel> appConsumersChannels;
    private static Map<String, Channel> appPordecersChannels;
    private Channel prodecerChannel;

    private static synchronized void regist(String appId) throws IOException {
        Channel channel = ChannelFactory.getChannel(EXCHANGE_REGION);
        String exchangeName = RabbitBroadcast.getAppExchangeName(appId);
        channel.exchangeDeclare(exchangeName, EXCHANGE_TYPE);
        HashMap<String, Object> argumentMap = new HashMap<String, Object>();
        argumentMap.put("x-max-length", 1000000);
        argumentMap.put("kd-instanceId", Instance.getInstanceId());
        argumentMap.put("kd-ip", NetAddressUtils.getLocalIpAddress());
        String queueName = channel.queueDeclare("broadcast_" + Instance.getInstanceId() + "_" + appId, false, true, true, argumentMap).getQueue();
        channel.queueBind(queueName, exchangeName, "");
        RabbitBroadcastConsumer consumer = new RabbitBroadcastConsumer(channel);
        String consumerTag = "kd-" + queueName;
        channel.basicConsume(queueName, false, consumerTag, false, false, argumentMap, (Consumer)consumer);
        appConsumersChannels.put(appId, channel);
    }

    private static final String getAppExchangeName(String appId) {
        return EXCHANGE_NAME + "_" + appId;
    }

    private static synchronized void regist() throws IOException {
        Channel channel = ChannelFactory.getChannel(EXCHANGE_REGION);
        channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE);
        HashMap<String, Object> argumentMap = new HashMap<String, Object>();
        argumentMap.put("x-max-length", 1000000);
        argumentMap.put("kd-instanceId", Instance.getInstanceId());
        argumentMap.put("kd-ip", NetAddressUtils.getLocalIpAddress());
        String queueName = channel.queueDeclare("broadcast_" + Instance.getInstanceId(), false, true, true, argumentMap).getQueue();
        channel.queueBind(queueName, EXCHANGE_NAME, "");
        RabbitBroadcastConsumer consumer = new RabbitBroadcastConsumer(channel);
        String consumerTag = "kd-" + queueName;
        channel.basicConsume(queueName, false, consumerTag, false, false, argumentMap, (Consumer)consumer);
        consumerChannel = channel;
    }

    @Override
    public void registerBroadcastConsumer() {
        try {
            RabbitBroadcast.regist();
            if (!Instance.isAppSplit()) {
                return;
            }
            String[] appIds = Instance.getAppIds();
            if (appIds == null) {
                return;
            }
            Set<String> supportedAppids = Configure.getSupportBroadcastAppids();
            for (String appId : appIds) {
                if (!supportedAppids.contains(appId)) continue;
                RabbitBroadcast.regist(appId);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't init mqchannel"});
        }
    }

    @Override
    public void broadcastMessage(byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        Channel ch = null;
        try {
            ch = this.getBoradcastProducerChannel();
            ch.basicPublish(EXCHANGE_NAME, "", null, message);
        }
        catch (IOException e) {
            try {
                if (ch != null) {
                    Connection con = ch.getConnection();
                    con.abort();
                }
            }
            catch (Exception ee) {
                logger.error("broadcast Message exception", (Throwable)e);
            }
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"boradcast message error "});
        }
    }

    private boolean broadcastDisable() {
        return Boolean.getBoolean("boradcast.disable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getBoradcastProducerChannel() {
        if (!ChannelFactory.isChannelNeedReBuild(this.prodecerChannel)) {
            return this.prodecerChannel;
        }
        Class<BroadcastService> clazz = BroadcastService.class;
        synchronized (BroadcastService.class) {
            if (ChannelFactory.isChannelNeedReBuild(this.prodecerChannel)) {
                try {
                    Channel channel = ChannelFactory.getChannel(EXCHANGE_REGION);
                    if (channel == null) {
                        throw new KDException(BosErrorCode.mqException, new Object[]{"get mqchannel  is null"});
                    }
                    channel.exchangeDeclare(EXCHANGE_NAME, EXCHANGE_TYPE);
                    this.prodecerChannel = channel;
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't create channel"});
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.prodecerChannel;
        }
    }

    @Override
    public void broadcastMessage(String appid, byte[] message) {
        if (this.broadcastDisable()) {
            return;
        }
        if (!Configure.getSupportBroadcastAppids().contains(appid)) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"app " + appid + " not support broadcast"});
        }
        try {
            if (Instance.isAppSplit()) {
                this.getBoradcastProducerChannel(appid).basicPublish(RabbitBroadcast.getAppExchangeName(appid), "", null, message);
            } else {
                this.getBoradcastProducerChannel().basicPublish(EXCHANGE_NAME, "", null, message);
            }
        }
        catch (IOException e) {
            try {
                this.getBoradcastProducerChannel(appid).getConnection().abort();
            }
            catch (Exception ee) {
                logger.error("broadcast Message exception", (Throwable)ee);
            }
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{appid + " appboradcast message error "});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getBoradcastProducerChannel(String appid) {
        Channel prodecerChannel = appPordecersChannels.get(appid);
        if (!ChannelFactory.isChannelNeedReBuild(prodecerChannel)) {
            return prodecerChannel;
        }
        Class<BroadcastService> clazz = BroadcastService.class;
        synchronized (BroadcastService.class) {
            if (ChannelFactory.isChannelNeedReBuild(prodecerChannel)) {
                try {
                    Channel channel = ChannelFactory.getChannel(EXCHANGE_REGION);
                    if (channel == null) {
                        throw new KDException(BosErrorCode.mqException, new Object[]{appid + " get app mqchannel  is null"});
                    }
                    channel.exchangeDeclare(RabbitBroadcast.getAppExchangeName(appid), EXCHANGE_TYPE);
                    prodecerChannel = channel;
                    appPordecersChannels.put(appid, prodecerChannel);
                }
                catch (IOException e) {
                    throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{appid + " can't create channel"});
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return prodecerChannel;
        }
    }

    static {
        appConsumersChannels = new HashMap<String, Channel>();
        appPordecersChannels = new HashMap<String, Channel>();
        String type = QueueManager.getMQType(EXCHANGE_REGION);
        if ("rabbitmq".equals(type)) {
            Timer timer = new Timer("MQConsumerChannelMonitor");
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (ChannelFactory.isChannelNeedReBuild(consumerChannel)) {
                        try {
                            logger.error("broadcast consumer mqchannel is closed,re registe ");
                            RabbitBroadcast.regist();
                        }
                        catch (Exception e) {
                            logger.error("registe broadcast consumer error,can't init mqchannel", (Throwable)e);
                        }
                    }
                    if (Instance.isAppSplit()) {
                        appConsumersChannels.forEach((appid, channel) -> {
                            if (ChannelFactory.isChannelNeedReBuild(channel)) {
                                try {
                                    RabbitBroadcast.regist(appid);
                                }
                                catch (Exception e) {
                                    logger.error("registe app broadcast consumer error,can't init mqchannel,app is " + appid, (Throwable)e);
                                }
                            }
                        });
                    }
                }
            }, 300000L, 60000L);
        }
    }
}

