/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQImpl;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.metric.Counter;
import kd.bos.metric.MetricSystem;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.delay.RabbitMQDelayManager;
import kd.bos.mq.dlx.DLXConfig;
import kd.bos.mq.dlx.DLXMesPubFactory;
import kd.bos.mq.dlx.DLXStrategy;
import kd.bos.mq.dlx.MessageRecord;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.Config;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rabbit.RabbitAcker;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.TimeCacheMap;
import kd.bos.mq.support.TranscationSupport;
import kd.bos.thread.SetThreadName;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

public class RabbitConsumer
extends DefaultConsumer
implements Consumer {
    private static Counter noRequestContextCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.noRequestContextCounter");
    private static Counter decodeMessageErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.decodeMessageErrorCounter");
    private static Counter handlerMessagerErrorCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerOnMessagerErrorCounter");
    private static Counter handlerMessagerTranscationRollBackCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRollBackCounter");
    private static Counter handlerMessagerTranscationRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerTranscationRepeateCounter");
    private static Counter handlerMessagerRepeateCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.handlerMessagerRepeateCounter");
    private static Counter consumerounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.Counter");
    private static Counter activeCounter = MetricSystem.counter((String)"kd.metrics.mq.consumer.activeConsumers");
    private static String maxPoolCount = System.getProperty("mq.consumer.maxpoolsize", "32");
    private static ThreadPool pool = ThreadPools.newCachedThreadPool((String)"RabbitMqAsyncConsumer", (int)5, (int)Integer.parseInt(maxPoolCount));
    private static Map<String, AtomicInteger> queueActiveCountMap = new ConcurrentHashMap<String, AtomicInteger>(2);
    private final AtomicInteger queueActiveThreadCount;
    private Channel channel;
    private String queue;
    private boolean autoAck;
    private int concurrency;
    private int maxQueueLength;
    private MessageConsumer mc;
    private String region;
    private volatile boolean isStartedFlag;
    private TimeCacheMap<AtomicInteger> messageRepeatTimes = new TimeCacheMap(300);
    private Date startAt;

    public RabbitConsumer(String region, String queue, boolean autoAck, int concurrency, MessageConsumer mc, int maxQueueLength, Channel chanel) {
        super(chanel);
        this.channel = chanel;
        this.region = region;
        this.queue = queue;
        this.autoAck = autoAck;
        this.concurrency = concurrency;
        this.mc = mc;
        this.maxQueueLength = maxQueueLength;
        this.queueActiveThreadCount = queueActiveCountMap.computeIfAbsent(region + queue, k -> new AtomicInteger(0));
        consumerounter.inc();
    }

    private static boolean isforbiddenTenantCode(String tenantCode) {
        if (Instance.isPausedServiceByMonitor()) {
            return true;
        }
        String fbStr = System.getProperty("mq.consume.forbidden.tenantcodes");
        if (fbStr == null) {
            return false;
        }
        String[] fbTenantCodes = fbStr.split(",|;");
        if (fbTenantCodes == null) {
            return false;
        }
        for (String fbcode : fbTenantCodes) {
            if (!tenantCode.equalsIgnoreCase(fbcode)) continue;
            return true;
        }
        return false;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel chanel) {
        this.channel = chanel;
    }

    @Override
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getQueueName() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.mc;
    }

    @Override
    public void start() {
        this.isStartedFlag = true;
        this.startAt = new Date();
        if (this.queueActiveThreadCount.get() > 0) {
            ExceptionLogger.warn("rabbitConsumer not start because of activeThread is " + this.queueActiveThreadCount.get() + ",need " + this.concurrency + "," + this.queue);
            try {
                this.channel.close();
            }
            catch (Exception e) {
                ExceptionLogger.log("Can't close channel for queue " + this.queue, e);
            }
            return;
        }
        QueueManager.declareIfNeed(this.channel, this.region, this.queue, this.maxQueueLength);
        try {
            this.channel.basicQos(this.concurrency);
            HashMap<String, String> argumentMap = new HashMap<String, String>();
            argumentMap.put("kd-instanceId", Instance.getInstanceId());
            argumentMap.put("kd-ip", NetAddressUtils.getLocalIpAddress());
            String consumerTag = "kd-" + this.queue + "-" + Instance.getInstanceId();
            this.channel.basicConsume(this.queue, this.autoAck, consumerTag, false, false, argumentMap, (com.rabbitmq.client.Consumer)this);
        }
        catch (IOException e) {
            ExceptionLogger.log("Can't init consumer for queue " + this.queue, e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't init consumer for queue " + this.queue});
        }
    }

    @Override
    public void $$stop() {
        try {
            this.isStartedFlag = false;
            this.channel.close();
        }
        catch (Exception e) {
            ExceptionLogger.log("error when stop mqchannel" + this.queue, e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStartedFlag;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        if (Config.disableParallelConsume()) {
            this.innerHandleDelivery(consumerTag, envelope, properties, body);
        } else {
            pool.execute(() -> {
                try {
                    this.queueActiveThreadCount.incrementAndGet();
                    this.innerHandleDelivery(consumerTag, envelope, properties, body);
                }
                finally {
                    this.queueActiveThreadCount.decrementAndGet();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerHandleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
        Message message;
        RabbitAcker acker = new RabbitAcker(this.channel, this.autoAck);
        String messageId = String.valueOf(envelope.getDeliveryTag());
        try {
            message = this.toMessage(body);
        }
        catch (Exception e) {
            acker.discard(messageId);
            decodeMessageErrorCounter.inc();
            ExceptionLogger.log("MQError:toMessage exception, auto discard, messageId=" + messageId + ",queue:" + this.queue, e);
            return;
        }
        if (this.renewDelay(messageId, message, acker)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)message.getKdtxId())) {
            this._handleDtxDelivery(envelope, message, acker);
            return;
        }
        long messageInnerId = message.getInnerId();
        if (messageInnerId != 0L) {
            AtomicInteger ai = this.messageRepeatTimes.get(messageInnerId);
            if (ai == null) {
                ai = new AtomicInteger(0);
                this.messageRepeatTimes.put(messageInnerId, ai);
            }
            if (ai.getAndIncrement() > 100) {
                acker.discard(messageId);
                this.messageRepeatTimes.remove(messageInnerId);
                handlerMessagerRepeateCounter.inc();
                ExceptionLogger.log("MQError:Repeat send message too many times, auto discard, messageId=" + messageId + ",queue=" + this.queue);
                return;
            }
        }
        try {
            this._handleDelivery(consumerTag, envelope, messageId, message, acker);
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                int tryTimes = TranscationSupport.instance().tryTimes(String.valueOf(message.getInnerId()));
                if (tryTimes > 30) {
                    acker.discard(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception,try times >30, auto discard, messageId=" + messageId, t);
                } else {
                    this.applyWait(tryTimes);
                    acker.deny(messageId);
                    ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
                }
            } else {
                ExceptionLogger.log("MQError:handleDelivery uncatched exception, messageId=" + messageId, t);
            }
        }
        finally {
            if (!acker.isDenied()) {
                this.messageRepeatTimes.remove(messageInnerId);
            }
        }
    }

    private boolean renewDelay(String messageId, Message message, RabbitAcker acker) {
        int remainSeconds = (int)((message.getStartDeliverTime() - System.currentTimeMillis()) / 1000L);
        if (message.getStartDeliverTime() > 0L && remainSeconds > 0) {
            try {
                MetaTime metaTime = DelayControlManager.selectMaxMetaTime(remainSeconds);
                byte[] bytes = MessageSerde.get().encode(message);
                RabbitMQDelayManager.publishDelayMessageConfirmModel(bytes, this.channel, this.queue, metaTime);
                acker.discard(messageId);
            }
            catch (Exception e) {
                acker.deny(messageId);
                ExceptionLogger.log("renew delay for queue " + this.queue + " error ", e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _handleDtxDelivery(Envelope envelope, Message message, RabbitAcker acker) {
        String messageId = String.valueOf(envelope.getDeliveryTag());
        boolean isManual = false;
        DBRoute dbRoute = DBRoute.of((String)message.getRouteKey());
        boolean dbTransEnd = true;
        try {
            boolean b = this.createTraceAndRequestContext(message);
            if (!b) {
                acker.discard(messageId);
                KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
                noRequestContextCounter.inc();
                return;
            }
            boolean isReceived = KdtxSupport.isReceived(dbRoute, message.getKdtxId(), message.getSeq());
            if (!isReceived) {
                try {
                    KdtxSupport.received(dbRoute, message.getKdtxId(), message.getSeq());
                }
                catch (Exception e) {
                    acker.deny(messageId);
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "MQError:message update receive statue error, will requeue", true);
                    noRequestContextCounter.inc();
                    KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
                    if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                        if (isManual) {
                            KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                        }
                        KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
                    }
                    return;
                }
            } else if (!envelope.isRedeliver()) {
                isManual = KdtxSupport.isManual(message.getKdtxId(), message.getSeq());
                if (!isManual) {
                    acker.discard(messageId);
                    return;
                }
            } else if (KdtxSupport.mqSecondCompensate(message.getKdtxId(), message.getSeq())) {
                acker.discard(messageId);
                return;
            }
            if (message.getKdtxId().equals(message.getTranscationTag())) {
                if (TranscationSupport.instance().isRollBack(message.getTranscationTag())) {
                    acker.isDiscarded();
                    return;
                }
                if (!TranscationSupport.instance().existXid(message.getRouteKey(), message.getTranscationTag())) {
                    acker.isDiscarded();
                    dbTransEnd = false;
                    return;
                }
            }
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), String.format("message[isReceived:%s,isManual:%s] start execute", isReceived, isManual), false);
            RequestContext rc = RequestContext.get();
            if (RabbitConsumer.isforbiddenTenantCode(rc.getTenantCode())) {
                LockSupport.parkNanos(1000000000L);
                acker.deny(messageId);
                return;
            }
            if (DLXConfig.isSendDLX(message.getRequestContext())) {
                message.setDLXMessage(true);
                DLXMesPubFactory.getDLXMessagePublisher().sendMessage(this.region, this.queue, message, messageId, acker);
                return;
            }
            this.doTraceAndConsume(envelope, messageId, message, acker);
            if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
                MessageRecord.update(2, message.getInnerId());
            }
        }
        catch (Error | Exception t) {
            if (!acker.hasDone()) {
                this.applyWait(1);
                acker.deny(messageId);
                KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "common exception auto deny,errorMsg:" + t.getMessage(), true);
            }
            ExceptionLogger.log("MQError:handleDelivery uncatched exception , auto deny, messageId=" + messageId, t);
        }
        finally {
            KdtxSupport.recordLog(message.getKdtxId(), message.getSeq(), "execute finished", false);
            if (acker.isAcked() || acker.isDiscarded() && dbTransEnd) {
                if (isManual) {
                    KdtxSupport.compensateSuccess(message.getKdtxId(), message.getSeq());
                }
                KdtxSupport.endConsumer(dbRoute, message.getKdtxId());
            }
        }
    }

    public void _handleDelivery(String consumerTag, Envelope envelope, String messageId, Message message, RabbitAcker acker) {
        boolean b = this.createTraceAndRequestContext(message);
        if (!b) {
            acker.discard(messageId);
            ExceptionLogger.log("MQError:message has`t requestContext, auto discard, messageId=" + messageId);
            noRequestContextCounter.inc();
            return;
        }
        RequestContext rc = RequestContext.get();
        if (RabbitConsumer.isforbiddenTenantCode(rc.getTenantCode())) {
            LockSupport.parkNanos(1000000000L);
            acker.deny(messageId);
            return;
        }
        if (DLXConfig.isSendDLX(message.getRequestContext())) {
            message.setDLXMessage(true);
            DLXMesPubFactory.getDLXMessagePublisher().sendMessage(this.region, this.queue, message, messageId, acker);
            return;
        }
        if (!this.isTransactionSubmit(messageId, message, acker)) {
            return;
        }
        this.doTraceAndConsume(envelope, messageId, message, acker);
        if (message.isDLXMessage() && DLXConfig.getDLXStrategy() == DLXStrategy.DEFAULT) {
            MessageRecord.update(2, message.getInnerId());
        }
    }

    private boolean isTransactionSubmit(String messageId, Message message, RabbitAcker acker) {
        String xid = message.getTranscationTag();
        if (xid != null && !this.autoAck) {
            boolean existXid;
            int loop = -1;
            int max = 3;
            boolean isMessageTimeout = this.isMessageTimeout(message);
            do {
                if (TranscationSupport.instance().isRollBack(xid)) {
                    acker.discard(messageId);
                    handlerMessagerTranscationRollBackCounter.inc();
                    return false;
                }
                existXid = TranscationSupport.instance().existXid(message.getRouteKey(), xid);
                if (max == ++loop || isMessageTimeout) break;
                this.applyWait(loop);
            } while (!existXid);
            if (!existXid) {
                this.waitDeal(messageId, message, acker, xid);
                return false;
            }
            String messageRouteKey = message.getRouteKey();
            String consumeRouteKey = this.mc.getRouteKey();
            if (consumeRouteKey == null) {
                consumeRouteKey = messageRouteKey;
            }
            if (TranscationSupport.instance().existConsumedId(consumeRouteKey, xid)) {
                acker.discard(messageId);
                handlerMessagerTranscationRepeateCounter.inc();
                return false;
            }
            String _consumeRouteKey = consumeRouteKey;
            acker.setAckedCallBack(() -> {
                try {
                    TranscationSupport.instance().insertConsumed(_consumeRouteKey, xid);
                    TranscationSupport.instance().deleteXid(messageRouteKey, xid);
                }
                catch (Exception e) {
                    ExceptionLogger.log("mq TranscationSupport error of acktion" + messageId, e);
                }
            });
        }
        return true;
    }

    private void waitDeal(String messageId, Message message, RabbitAcker acker, String xid) {
        if (message.getRetryTimes() != -1) {
            this.delayStrategy(messageId, message, acker);
        } else {
            this.timesStrategy(messageId, message, acker, xid);
        }
    }

    private void delayStrategy(String messageId, Message message, RabbitAcker acker) {
        int retryTimes = message.getRetryTimes();
        if (retryTimes >= 14) {
            acker.discard(messageId);
        } else {
            int nextDelayLevel = retryTimes + 3;
            message.setRetryTimes(retryTimes + 1);
            byte[] bytes = MessageSerde.get().encode(message);
            MetaTime delayLevel = MetaTime.genInstanceByLevel(nextDelayLevel);
            if (delayLevel != null) {
                try {
                    RabbitMQDelayManager.publishDelayMessageConfirmModel(bytes, this.channel, this.queue, delayLevel);
                    acker.discard(messageId);
                }
                catch (Exception e) {
                    acker.deny(messageId);
                    ExceptionLogger.log("publishDelayMessageConfirmModel for queue " + this.queue + " error ", e);
                }
            }
        }
    }

    private void timesStrategy(String messageId, Message message, RabbitAcker acker, String xid) {
        int tryTimes = TranscationSupport.instance().tryTimes(xid);
        if (tryTimes > 30 || this.isMessageTimeout(message)) {
            acker.discard(messageId);
            handlerMessagerTranscationRollBackCounter.inc();
        } else {
            this.applyWait(tryTimes);
            acker.deny(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTraceAndConsume(Envelope envelope, String messageId, Message message, RabbitAcker acker) {
        try (TraceSpan span = Tracer.create((String)"MQConsumer", (String)"onMessage", (boolean)true);){
            span.addTag("messageId", messageId);
            span.addTag("resent", Boolean.toString(envelope.isRedeliver()));
            span.addTag("queue", this.queue);
            span.addTag("region", this.region);
            try {
                activeCounter.inc();
                ConsumerStats.incrementActiveCount(this.queue, messageId);
                this.mc.onMessage(message.getBody(), messageId, envelope.isRedeliver(), acker);
                if (!acker.hasDone()) {
                    acker.ack(messageId);
                }
            }
            catch (Exception t) {
                if (!acker.hasDone()) {
                    handlerMessagerErrorCounter.inc();
                    ExceptionLogger.log("MQError:onMessage uncatched exception, auto discard, messageId=" + messageId);
                    acker.discard(messageId);
                } else {
                    ExceptionLogger.log("MQError:onMessage uncatched exception, messageId=" + messageId);
                }
            }
            finally {
                activeCounter.dec();
                ConsumerStats.decrementActiveCount(this.queue, messageId);
            }
        }
    }

    private boolean isMessageTimeout(Message message) {
        long timeout = (long)Integer.parseInt(System.getProperty("mq.trasncation.message.waittime", "300")) * 1000L;
        return System.currentTimeMillis() - message.getMessageTime() > timeout;
    }

    private boolean createTraceAndRequestContext(Message message) {
        RequestContext rc = message.getRequestContext();
        if (rc == null) {
            return false;
        }
        String traceId = TraceIdUtil.createTraceIdString();
        SetThreadName.setTraceId((String)traceId);
        rc.setTraceId(traceId);
        RequestContextCreator.restoreForMQ((RequestContext)rc);
        return true;
    }

    private void applyWait(int tryTimes) {
        if (tryTimes < 1) {
            return;
        }
        if (tryTimes == 1) {
            LockSupport.parkNanos(100000000L);
        } else {
            LockSupport.parkNanos(1000000000L * (long)tryTimes);
        }
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException e) {
        int replyCode;
        super.handleShutdownSignal(consumerTag, e);
        if (e.getReason() instanceof AMQImpl.Channel.Close && (replyCode = ((AMQImpl.Channel.Close)e.getReason()).getReplyCode()) != 200) {
            if (this.queueActiveThreadCount.get() > 0) {
                ExceptionLogger.warn("rabbitConsumer not restart because of activeThread is " + this.queueActiveThreadCount.get() + ",need " + this.concurrency + "," + this.queue);
                return;
            }
            try {
                this.channel = ChannelFactory.getChannel(this.region);
                this.channel.basicQos(this.concurrency);
                HashMap<String, String> argumentMap = new HashMap<String, String>();
                argumentMap.put("kd-instanceId", Instance.getInstanceId());
                argumentMap.put("kd-ip", NetAddressUtils.getLocalIpAddress());
                String newConsumerTag = "kd-" + this.queue + "-" + Instance.getInstanceId();
                this.channel.basicConsume(this.queue, this.autoAck, newConsumerTag, false, false, argumentMap, (com.rabbitmq.client.Consumer)this);
                this.startAt = new Date();
                ExceptionLogger.log("reCreateConsumerChannelForQueue:" + this.queue, (Throwable)e);
            }
            catch (Exception e1) {
                ExceptionLogger.log("Can't init consumer for queue " + this.queue, e1);
                throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't init consumer for queue " + this.queue});
            }
        }
    }

    private Message toMessage(byte[] body) {
        return MessageSerde.get().decode(body);
    }

    @FunctionalInterface
    public static interface AckedCallBack {
        public void call();
    }
}

