/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.constant.SceneCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.delay.RabbitMQDelayManager;
import kd.bos.mq.rabbit.Config;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rabbit.PublisherChannels;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import kd.bos.util.ExceptionUtils;

public class RabbitPublisher
extends PublisherSupport {
    private static Log logger = LogFactory.getLog(RabbitPublisher.class);
    private static final String RABBIT_TRACE_NAME = "RabbitPublisher";
    private Channel channel;
    private String queueName;
    private String region;
    private String stack;
    private static ThreadLocal<CloseablePublishers> local = new ThreadLocal<CloseablePublishers>(){

        @Override
        protected CloseablePublishers initialValue() {
            return new CloseablePublishers();
        }
    };

    public RabbitPublisher(Channel channel, String queueName, boolean transactional, String region) {
        super(transactional);
        this.channel = channel;
        this.queueName = queueName;
        this.region = region;
        this.stack = ExceptionUtils.getExceptionStackTraceMessage((Exception)new Exception());
        CloseablePublishers cp = local.get();
        int max = Integer.getInteger("mq.publish.maxsizeinthread", 20);
        if (cp.size() >= max) {
            String message = "MQ publisher leak! More than " + max + " publisher in current thread. ";
            logger.warn(message + "detail:" + cp.toString() + " ,stack:" + cp.getStacks());
        }
        local.get().put(this);
    }

    @Override
    protected void _beginTrans() {
        try {
            this.channel.txSelect();
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.rabbitmqException, "can't begin transaction", (Throwable)e);
        }
    }

    @Override
    protected void _commitTrans() {
        try {
            this.channel.txCommit();
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.rabbitmqException, "can't commit transaction", (Throwable)e);
        }
    }

    @Override
    protected void _rollbackTrans() {
        try {
            this.channel.txRollback();
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.rabbitmqException, "can't rollback transaction", (Throwable)e);
        }
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.publishInDbTranscation(null, message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.publishDelayInDbTranscation(routKey, message, -1);
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.publishDelayInDbTranscation(null, message, seconds);
    }

    private void publishDelayInDbTranscation(String routKey, Object message, int seconds) {
        String writtenRouteKey = TX.getWrittenRouteKey();
        this.publish0(message, null, true, writtenRouteKey == null ? routKey : writtenRouteKey, seconds);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.publish0(message, null, false, null, seconds);
    }

    private void publish0(Object message) {
        this.publish0(message, null, false, null);
    }

    private void publish0(Object message, String consumeSynchronizeTag, boolean indbtrans, String routeKey) {
        this.publish0(message, consumeSynchronizeTag, indbtrans, routeKey, -1);
    }

    private void publish0(Object body, String consumeSynchronizeTag, boolean indbtrans, String routeKey, int seconds) {
        Limiter.checkAndRecord((String)SceneCode.MQ.getCode());
        if (!PublisherSupport.isCanPublishMessage(this.queueName)) {
            throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"The current node has been discarded due to grayscale completion,queue name is " + this.queueName});
        }
        try (TraceSpan span = Tracer.create((String)RABBIT_TRACE_NAME, (String)"publish0", (boolean)true);){
            span.addTag("queueName", this.queueName);
            Connection connection = this.channel.getConnection();
            TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)(connection.getAddress() + ":" + connection.getPort()), (String)"RabbitMQ", (String)"mq");
            this.queueName = PublisherSupport.getStandardQueue(this.queueName);
            String publishQueueName = ConsumerSupport.getAcrossNodePublishQueueNameGray(this.queueName);
            Message message = this.toMessage(body);
            message.setConsumeSynchronizeTag(consumeSynchronizeTag);
            if (indbtrans) {
                if (routeKey == null) {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{"routKey can not be null"});
                }
                if (KdtxSupport.isDtxEnable()) {
                    this.startDTXAndRegistry(message, routeKey, this.region, publishQueueName);
                    return;
                }
                this.recordMqTrans(routeKey, message);
            }
            DelayControlManager.installDelayInfo(message, seconds);
            byte[] bytes = MessageSerde.get().encode(message);
            this.checkPayload(bytes, publishQueueName);
            if (message.getStartDeliverTime() > 0L) {
                MetaTime maxMetaTime = DelayControlManager.selectMaxMetaTime(seconds);
                RabbitMQDelayManager.publishDelayMessage(bytes, this.channel, publishQueueName, maxMetaTime);
            } else {
                this.realPublish(bytes, publishQueueName);
            }
        }
        catch (Exception e) {
            logger.error("publish0 error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't publish"});
        }
    }

    private void realPublish(byte[] bytes, String publishQueueName) throws IOException {
        AMQP.BasicProperties p = new AMQP.BasicProperties().builder().deliveryMode(Integer.valueOf(2)).build();
        if (Config.reusePublisherChannel()) {
            PublisherChannels.getChannel(this.region).basicPublish("", publishQueueName, p, bytes);
        } else {
            this.channel.basicPublish("", publishQueueName, p, bytes);
        }
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        try {
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties().builder();
            builder.deliveryMode(Integer.valueOf(2));
            AMQP.BasicProperties p = builder.build();
            this.channel.confirmSelect();
            this.channel.basicPublish("", this.queueName, p, message);
            if (!this.channel.waitForConfirms(Long.getLong("mq.publish.confirm.timeout", 60000L).longValue())) {
                throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"publish fail: wait for confirm timeout"});
            }
        }
        catch (Exception e) {
            logger.error("$$publishConfirm error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[]{"can't publish"});
        }
    }

    private Message toMessage(Object body) {
        Message message = new Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(IDService.get().genLongId());
        message.setMessageTime();
        return message;
    }

    @Override
    public void close() {
        try {
            local.get().remove(this);
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void publish(Object message, String partitionKey) {
        throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"SimplePublisher can't publish message with partitionKey directly!"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"SimplePublisher can't publishInDbTranscation  with partitionKey directly!"});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        throw new KDException(BosErrorCode.rabbitmqException, new Object[]{"SimplePublisher can't publishDelay message with appId directly!"});
    }

    static class CloseablePublishers
    implements Closeable {
        private Map<RabbitPublisher, String> publishers = new ConcurrentHashMap<RabbitPublisher, String>(2);

        CloseablePublishers() {
        }

        @Override
        public void close() throws IOException {
            if (this.publishers.size() > 0) {
                logger.warn("MQ publisher leak! detail:" + this.getStacks());
            }
            this.publishers.forEach((v, s) -> {
                try {
                    v.close();
                }
                catch (Exception e) {
                    try {
                        ExceptionLogger.log("mqchannel close error", e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            this.publishers.clear();
        }

        public void put(RabbitPublisher c) {
            this.publishers.put(c, "");
        }

        public int size() {
            return this.publishers.size();
        }

        public void remove(RabbitPublisher c) {
            this.publishers.remove(c);
        }

        public String getStacks() {
            StringBuilder sb = new StringBuilder();
            AtomicInteger counter = new AtomicInteger(0);
            this.publishers.forEach((publisher, s) -> {
                if (counter.incrementAndGet() < 100) {
                    sb.append(((RabbitPublisher)publisher).queueName).append("#").append(((RabbitPublisher)publisher).region).append(" ,").append(((RabbitPublisher)publisher).stack);
                }
            });
            return sb.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            AtomicInteger counter = new AtomicInteger(0);
            this.publishers.forEach((publisher, s) -> {
                if (counter.incrementAndGet() < 100) {
                    sb.append(((RabbitPublisher)publisher).queueName).append("#").append(((RabbitPublisher)publisher).region).append(" ,");
                }
            });
            return sb.toString();
        }
    }
}

