/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rabbit;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.QueueManager;

public class RabbitQueueDeclare
implements QueueDeclare {
    private static final Log logger = LogFactory.getLog(RabbitQueueDeclare.class);
    private static Map<String, Channel> channels;

    @Override
    public void queueDeclare(String region, String queueRealName, boolean isDuration, Map<String, Object> args) {
        try {
            RabbitQueueDeclare.getChannel(region).queueDeclare(queueRealName, isDuration, false, false, args);
        }
        catch (Exception e) {
            ShutdownSignalException sse;
            if (e.getCause() != null && e.getCause() instanceof ShutdownSignalException && (sse = (ShutdownSignalException)e.getCause()) != null && sse.getMessage() != null && sse.getMessage().indexOf("inequivalent arg 'x-max-length'") > 0) {
                try {
                    if (sse.getMessage().indexOf("but current is none") > 0) {
                        RabbitQueueDeclare.getChannel(region).queueDelete(queueRealName);
                        RabbitQueueDeclare.getChannel(region).queueDeclare(queueRealName, isDuration, false, false, args);
                    }
                }
                catch (Exception e1) {
                    ExceptionLogger.log("queueDeclare", e1);
                }
                return;
            }
            throw new KDException((Throwable)e, BosErrorCode.rabbitmqException, new Object[0]);
        }
    }

    @Override
    public RabbitConsumer getConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef, MessageConsumer mc) {
        int concurrency = QueueManager.getConcurrency(consumerDef);
        concurrency = ConfigForInitConsumer.getConcurrency(region, queueName, concurrency);
        Channel channel = ChannelFactory.getChannel(region);
        RabbitConsumer consumer = new RabbitConsumer(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength(), channel);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Channel getChannel(String region) {
        Channel channel = channels.get(region);
        if (ChannelFactory.isChannelNeedReBuild(channel)) {
            Map<String, Channel> map = channels;
            synchronized (map) {
                channel = channels.get(region);
                if (ChannelFactory.isChannelNeedReBuild(channel)) {
                    channel = ChannelFactory.getChannel(region);
                    channels.put(region, channel);
                }
            }
        }
        return channel;
    }

    static {
        if (!Instance.isLightWeightDeploy()) {
            Timer timer = new Timer("MQConsumerChannelMonitor");
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        boolean consumerCountEnable = Boolean.parseBoolean(System.getProperty("mq.rabbitmq.consumerCount.enable", "true"));
                        QueueManager.getConsumers().forEach((k, v) -> {
                            if (!(v instanceof RabbitConsumer)) {
                                return;
                            }
                            RabbitConsumer consumer = (RabbitConsumer)v;
                            Channel channel = consumer.getChannel();
                            if (consumer.isStarted()) {
                                if (Instance.isPausedServiceByMonitor()) {
                                    try {
                                        if (channel.isOpen()) {
                                            channel.close();
                                        }
                                    }
                                    catch (Exception e) {
                                        logger.error("consumer mqchannel error ", (Throwable)e);
                                    }
                                } else if (ChannelFactory.isChannelNeedReBuild(channel)) {
                                    logger.warn("mqchannel is closed,queue is " + k + ",");
                                    consumer.setChannel(ChannelFactory.getChannel(consumer.getRegion()));
                                    consumer.start();
                                } else if (consumerCountEnable) {
                                    String queueName = consumer.getQueueName();
                                    try {
                                        long consumerCount = channel.consumerCount(queueName);
                                        if (consumerCount == 0L) {
                                            logger.warn(queueName + " consumerCount=0,restart consumer now");
                                            if (ChannelFactory.isChannelNeedReBuild(channel)) {
                                                logger.warn("mqchannel is closed,queue is " + k + ",");
                                                consumer.setChannel(ChannelFactory.getChannel(consumer.getRegion()));
                                            }
                                            consumer.start();
                                        }
                                    }
                                    catch (IOException e) {
                                        logger.error(queueName + " consumerCountError:", (Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error("consumer mqchannel error ", (Throwable)e);
                    }
                }
            }, 300000L, 60000L);
        }
        channels = new ConcurrentHashMap<String, Channel>();
    }
}

