/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.remoting.RPCHook;

public class ConsumerFactory {
    private static Log logger = LogFactory.getLog(ConsumerFactory.class);

    public static DefaultMQPushConsumer getConsumer(String region, String queueName) {
        DefaultMQPushConsumer consumer;
        try {
            String serverKey = ProducerFactory.getRegionServerKey(region);
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueName);
            RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
            RocketMQTopicUtil.createSubscriptionGroup(rocketInfo, groupAndTopicName, rpcHook);
            consumer = new DefaultMQPushConsumer(groupAndTopicName, rpcHook, (AllocateMessageQueueStrategy)new AllocateMessageQueueAveragely());
            consumer.setNamesrvAddr(rocketInfo.getHost());
            consumer.subscribe(groupAndTopicName, "*");
            consumer.setInstanceName(RocketmqFactory.getInstanceName((String)region));
            consumer.setMqClientApiTimeout(30000);
        }
        catch (MQClientException e) {
            logger.error("ConsumerFactory getConsumer failed:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"ConsumerFactory getConsumer failed:" + e.getMessage()});
        }
        return consumer;
    }
}

