/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import kd.bos.mq.support.AckedCallBack;
import kd.bos.mq.support.MessageCommonAcker;

public class RocketAcker
implements MessageCommonAcker {
    private AckedCallBack ackedCallback;
    private int visitStatus = 0;
    private int ackStatus = 0;
    private boolean isBizInvoked;

    public int getAckStatus() {
        return this.ackStatus;
    }

    public void setAckStatus(int ackStatus) {
        this.ackStatus = ackStatus;
    }

    @Override
    public boolean hasDone() {
        return this.visitStatus > 0;
    }

    @Override
    public void ack(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(1);
        if (this.ackedCallback != null) {
            this.ackedCallback.call();
        }
    }

    @Override
    public void deny(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(2);
    }

    @Override
    public void discard(String messageId) {
        if (this.visitStatus++ > 0) {
            return;
        }
        this.setAckStatus(3);
    }

    @Override
    public boolean isDenied() {
        return this.ackStatus == 2;
    }

    @Override
    public void setAckedCallBack(AckedCallBack ackedCallback) {
        this.ackedCallback = ackedCallback;
    }

    @Override
    public boolean isAcked() {
        return this.ackStatus == 1;
    }

    @Override
    public boolean isDiscarded() {
        return this.ackStatus == 3;
    }

    public boolean isBizInvoked() {
        return this.isBizInvoked;
    }

    public void setBizInvoked(boolean bizInvoked) {
        this.isBizInvoked = bizInvoked;
    }
}

