/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Date;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ExceptionLogger;
import kd.bos.mq.rocket.ConsumerFactory;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketAcker;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerManager;
import kd.bos.mq.support.QueueManager;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.impl.MQClientAPIImpl;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.RPCHook;

public class RocketConsumer
implements Consumer {
    private static Log LOGGER = LogFactory.getLog(RocketConsumer.class);
    private String queue;
    private boolean autoAck;
    private int concurrency;
    private MessageConsumer mc;
    private String region;
    private DefaultMQPushConsumer defaultRocketConsumer;
    private volatile boolean isStartedFlag;
    private Date startAt;

    public RocketConsumer(String region, String queue, boolean autoAck, int concurrency, MessageConsumer mc, int maxQueueLength) {
        this.region = region;
        this.queue = queue;
        this.concurrency = concurrency;
        this.mc = mc;
        this.autoAck = autoAck;
        ConsumerManager.getConsumerounter().inc();
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getQueueName() {
        return this.queue;
    }

    @Override
    public boolean isAutoAck() {
        return this.autoAck;
    }

    @Override
    public MessageConsumer getMessageConsumer() {
        return this.mc;
    }

    @Override
    public Date getStartAt() {
        return this.startAt;
    }

    @Override
    public void start() {
        try {
            this.isStartedFlag = true;
            this.startAt = new Date();
            QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName(this.region, this.queue);
            QueueManager.declareIfNeed(null, this.region, this.queue, queueDef.getMaxQueueLength());
            this.defaultRocketConsumer = ConsumerFactory.getConsumer(this.region, this.queue);
            this.defaultRocketConsumer.setConsumeThreadMin(this.concurrency);
            this.defaultRocketConsumer.setConsumeThreadMax(this.concurrency);
            this.defaultRocketConsumer.setConsumeMessageBatchMaxSize(1);
            this.defaultRocketConsumer.registerMessageListener((msgs, context) -> {
                long beginTimestamp = System.currentTimeMillis();
                RocketAcker acker = new RocketAcker();
                MessageExt tempMsgExt = (MessageExt)msgs.get(0);
                try {
                    this.handleDelivery(tempMsgExt, acker);
                }
                catch (Throwable throwable) {
                    LOGGER.error("handleDeliveryError,topic:{},msgId:{},bizInvoked:{},errorMessage:{}", new Object[]{tempMsgExt.getTopic(), tempMsgExt.getMsgId(), acker.isBizInvoked(), throwable});
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
                long consumeRT = System.currentTimeMillis() - beginTimestamp;
                if (consumeRT >= this.defaultRocketConsumer.getConsumeTimeout() * 60L * 1000L) {
                    LOGGER.info("MessageConsumeTimeout,topic:{},msgId:{}", (Object)tempMsgExt.getTopic(), (Object)tempMsgExt.getMsgId());
                }
                if (acker.isDenied()) {
                    LOGGER.info("messageDeny,topic:{},msgId:{}", (Object)tempMsgExt.getTopic(), (Object)tempMsgExt.getMsgId());
                }
                return this.getConsumerStatus(acker.getAckStatus());
            });
            this.defaultRocketConsumer.start();
            String serverKey = ProducerFactory.getRegionServerKey(this.region);
            RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
            RPCHook rpcHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
            MQClientInstance mqClientInstance = MQClientManager.getInstance().getOrCreateMQClientInstance((ClientConfig)this.defaultRocketConsumer, rpcHook);
            MQClientAPIImpl mqClientAPIImpl = mqClientInstance.getMQClientAPIImpl();
            Class<?> remotingClientClass = mqClientAPIImpl.getRemotingClient().getClass();
            Field bootstrapField = remotingClientClass.getDeclaredField("bootstrap");
            AccessibleObject.setAccessible(new AccessibleObject[]{bootstrapField}, true);
            Bootstrap bootstrap = (Bootstrap)bootstrapField.get(mqClientAPIImpl.getRemotingClient());
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000);
        }
        catch (Exception e) {
            ExceptionLogger.log("Can't init consumer for queue " + this.queue, e);
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't init consumer for queue " + this.queue});
        }
    }

    private void handleDelivery(MessageExt msg, RocketAcker acker) {
        String messageId = msg.getMsgId();
        String topic = msg.getTopic();
        ConsumerManager.innerHandleDelivery(acker, this.mc, this.region, this.queue, messageId, msg.getReconsumeTimes(), msg.getBody(), topic);
    }

    private ConsumeConcurrentlyStatus getConsumerStatus(Integer status) {
        if (this.autoAck) {
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        }
        switch (status) {
            case 2: {
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
        }
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    @Override
    public void $$stop() {
        try {
            this.isStartedFlag = false;
            this.defaultRocketConsumer.shutdown();
        }
        catch (Exception e) {
            ExceptionLogger.log("error when stop mqchannel" + this.queue, e);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStartedFlag;
    }
}

