/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.init.MQInit;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketPublisher;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.producer.MQProducer;

public class RocketFactory
extends MQFactory {
    private static Logger logger = Logger.getLogger(RocketFactory.class);

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        if (region == null) {
            throw new KDException(BosErrorCode.rocketmqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueName});
        }
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.rocketmqConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return this._createPublisher(region, queueRealName);
    }

    private MessagePublisher _createPublisher(String region, String queueName) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
        MQProducer producer = ProducerFactory.getProducer(region, queueName, rocketInfo);
        try {
            QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueName);
            QueueManager.declareIfNeed(null, region, queueName, def.getMaxQueueLength());
            if (!"schedule".equals(region)) {
                ConsumerSupport.setAcrossNodeConsume(region, queueName, def);
            }
            return new RocketPublisher(producer, queueName, region, rocketInfo.getVhost());
        }
        catch (Exception t) {
            logger.error((Object)"RocketFactory.createSimplePublisher error", (Throwable)t);
            throw new KDException((Throwable)t, BosErrorCode.rocketmqException, new Object[]{"error when create publisher,region:" + region + ",queueName:" + queueName});
        }
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        return this._createPublisher(region, realQueueName);
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef def, String appid) {
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueNameWithAppid(region, def.getName(), appid);
        QueueManager._$defineQueue(region, def, appid);
        return this._createPublisher(region, queueRealName);
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queue, PartitionStrategy partitionStrategy) {
        throw new KDException(BosErrorCode.rocketmqException, new Object[]{"can't createPartitionPublisher directly!"});
    }
}

