/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.rocket.RocketConsumer;
import kd.bos.mq.rocket.RocketMQTopicUtil;
import kd.bos.mq.stat.ConsumerStats;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.MQGrayManager;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class RocketMQGrayManager
implements MQGrayManager {
    private static final Map<String, DefaultMQAdminExt> mqGrayManagerCache = new HashMap<String, DefaultMQAdminExt>(8);

    public static DefaultMQAdminExt getMQGrayManager(String region) throws MQClientException {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
        RPCHook aclRPCHook = ProducerFactory.getAclRPCHook(rocketInfo.getUsername(), rocketInfo.getPassword());
        DefaultMQAdminExt adminExt = RocketMQTopicUtil.getAdminExt(rocketInfo, aclRPCHook);
        return adminExt;
    }

    @Override
    public long messageCount(String region, String queueName) {
        ConsumeStats consumeStats;
        long messageCount = ConsumerStats.getActiveCount(queueName);
        try {
            String realQueueName = this.getRealQueueName(region, queueName);
            DefaultMQAdminExt mqAdmin = RocketMQGrayManager.getMQGrayManager(region);
            consumeStats = mqAdmin.examineConsumeStats(realQueueName);
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            throw new RuntimeException("query message count error on topic", e);
        }
        return messageCount += consumeStats.computeTotalDiff();
    }

    @Override
    public long consumerCount(String region, String queueName) {
        int consumerNum = 0;
        try {
            DefaultMQAdminExt mqAdmin = RocketMQGrayManager.getMQGrayManager(region);
            String realQueueName = this.getRealQueueName(region, queueName);
            ConsumerConnection consumerConnection = mqAdmin.examineConsumerConnectionInfo(realQueueName);
            HashSet connectionSet = consumerConnection.getConnectionSet();
            consumerNum += connectionSet.size();
        }
        catch (InterruptedException | MQClientException | RemotingException e) {
            throw new RuntimeException("query consumer count error, queueName: " + queueName, e);
        }
        catch (MQBrokerException brokerException) {
            consumerNum = 0;
        }
        return consumerNum;
    }

    @Override
    public void deleteQueue(String region, String queueName) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
        try {
            DefaultMQAdminExt mqAdmin = RocketMQGrayManager.getMQGrayManager(region);
            String realQueueName = this.getRealQueueName(region, queueName);
            ClusterInfo clusterInfo = mqAdmin.examineBrokerClusterInfo();
            HashMap clusterAddrTable = clusterInfo.getClusterAddrTable();
            Iterator it = clusterAddrTable.entrySet().iterator();
            String retryQueue = "%RETRY%" + realQueueName;
            while (it.hasNext()) {
                Map.Entry next = it.next();
                Set brokers = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)mqAdmin, (String)((String)next.getKey()));
                mqAdmin.deleteTopicInBroker(brokers, realQueueName);
                mqAdmin.deleteTopicInBroker(brokers, retryQueue);
            }
            Set<String> nameSrv = Collections.singleton(rocketInfo.getHost());
            mqAdmin.deleteTopicInNameServer(nameSrv, realQueueName, rocketInfo.getClustername());
            mqAdmin.deleteTopicInNameServer(nameSrv, retryQueue, rocketInfo.getClustername());
        }
        catch (InterruptedException | MQBrokerException | MQClientException | RemotingException e) {
            throw new RuntimeException("delete queue error", e);
        }
    }

    @Override
    public Consumer registerConsumer(String region, String queueName, boolean autoAck, int concurrency, MessageConsumer messageConsumer, int maxQueueLength) {
        try {
            RocketConsumer standardConsumer = new RocketConsumer(region, queueName, autoAck, concurrency, messageConsumer, maxQueueLength);
            standardConsumer.start();
            return standardConsumer;
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }

    @Override
    public void shutdown() {
        for (Map.Entry<String, DefaultMQAdminExt> next : mqGrayManagerCache.entrySet()) {
            DefaultMQAdminExt mqAdminExt = next.getValue();
            mqAdminExt.shutdown();
        }
        mqGrayManagerCache.clear();
    }

    private String getRealQueueName(String region, String queueName) {
        String serverKey = ProducerFactory.getRegionServerKey(region);
        RocketInfo rocketInfo = RocketmqFactory.getRocketInfo((String)serverKey);
        return ProducerFactory.getTopicAndGroupName(rocketInfo.getVhost(), queueName);
    }
}

