/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dlock.DLock;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.rocketmq.RocketInfo;
import kd.bos.rocketmq.RocketmqFactory;
import kd.bos.util.CollectionUtils;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;

public class RocketMQTopicUtil {
    private static final Log LOGGER = LogFactory.getLog(RocketMQTopicUtil.class);
    private static final Map<String, DefaultMQAdminExt> NAMESRV_ADMINEXT_MAP = new ConcurrentHashMap<String, DefaultMQAdminExt>(2);
    private static final Map<String, Set<String>> CLUSTERNAME_MASTERADDR_MAP = new ConcurrentHashMap<String, Set<String>>(2);
    private static final Map<String, ConcurrentMap<String, SubscriptionGroupConfig>> BROKERIP_SUBSCRIPTIONGROUP_MAP = new ConcurrentHashMap<String, ConcurrentMap<String, SubscriptionGroupConfig>>(2);
    private static final Object LOCKER = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createTopic(RocketInfo rocketInfo, String topic, int queueNums, RPCHook rpcHook) {
        try {
            DefaultMQAdminExt mqAdminExt = RocketMQTopicUtil.getAdminExt(rocketInfo, rpcHook);
            Set<String> masterSet = RocketMQTopicUtil.getMasterAddrSet((MQAdminExt)mqAdminExt, rocketInfo.getClustername());
            for (String address : masterSet) {
                TopicConfig topicConfig = mqAdminExt.examineTopicConfig(address, topic);
                if (topicConfig != null) continue;
                DLock dLock = DLock.create((String)(rocketInfo.getClustername() + "_" + topic));
                try {
                    if (!dLock.tryLock()) continue;
                    topicConfig = new TopicConfig(topic);
                    topicConfig.setReadQueueNums(queueNums);
                    topicConfig.setWriteQueueNums(queueNums);
                    mqAdminExt.createAndUpdateTopicConfig(address, topicConfig);
                }
                finally {
                    dLock.unlock();
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("error when RocketMQTopicUtil createTopic:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"error when RocketMQTopicUtil createTopic,namesrvAddr:" + rocketInfo.getHost() + ",topic:" + topic});
        }
    }

    public static boolean deleteTopic(RocketInfo rocketInfo, String topic, RPCHook rpcHook) {
        try {
            DefaultMQAdminExt mqAdminExt = RocketMQTopicUtil.getAdminExt(rocketInfo, rpcHook);
            mqAdminExt.deleteTopicInNameServer(new HashSet(mqAdminExt.getNameServerAddressList()), topic, rocketInfo.getClustername());
            Set<String> brokerAddressSet = RocketMQTopicUtil.getMasterAddrSet((MQAdminExt)mqAdminExt, rocketInfo.getClustername());
            mqAdminExt.deleteTopicInBroker(brokerAddressSet, topic);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("error when RocketMQTopicUtil deleteTopic:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"error when RocketMQTopicUtil deleteTopic,namesrvAddr:" + rocketInfo.getHost() + ",topic:" + topic});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSubscriptionGroup(RocketInfo rocketInfo, String groupName, RPCHook rpcHook) {
        try {
            DefaultMQAdminExt mqAdminExt = RocketMQTopicUtil.getAdminExt(rocketInfo, rpcHook);
            Set<String> masterSet = RocketMQTopicUtil.getMasterAddrSet((MQAdminExt)mqAdminExt, rocketInfo.getClustername());
            for (String address : masterSet) {
                ConcurrentMap subscriptionGroupConfigMap = BROKERIP_SUBSCRIPTIONGROUP_MAP.get(address);
                if (subscriptionGroupConfigMap == null) {
                    SubscriptionGroupWrapper allSubscriptionGroup = mqAdminExt.getUserSubscriptionGroup(address, 5000L);
                    BROKERIP_SUBSCRIPTIONGROUP_MAP.put(address, allSubscriptionGroup.getSubscriptionGroupTable());
                    subscriptionGroupConfigMap = allSubscriptionGroup.getSubscriptionGroupTable();
                }
                if (subscriptionGroupConfigMap.containsKey(groupName)) continue;
                DLock dLock = DLock.create((String)(rocketInfo.getClustername() + "_" + groupName));
                try {
                    if (!dLock.tryLock()) continue;
                    SubscriptionGroupConfig subscriptionGroupConfig = new SubscriptionGroupConfig();
                    subscriptionGroupConfig.setGroupName(groupName);
                    mqAdminExt.createAndUpdateSubscriptionGroupConfig(address, subscriptionGroupConfig);
                }
                finally {
                    dLock.unlock();
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("error when RocketMQTopicUtil createSubscriptionGroup:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"error when RocketMQTopicUtil createSubscriptionGroup,namesrvAddr:" + rocketInfo.getHost() + ",groupName:" + groupName});
        }
    }

    public static boolean deleteSubscriptionGroup(RocketInfo rocketInfo, String groupName, RPCHook rpcHook) {
        try {
            DefaultMQAdminExt mqAdminExt = RocketMQTopicUtil.getAdminExt(rocketInfo, rpcHook);
            Set<String> masterSet = RocketMQTopicUtil.getMasterAddrSet((MQAdminExt)mqAdminExt, rocketInfo.getClustername());
            for (String masterIp : masterSet) {
                mqAdminExt.deleteSubscriptionGroup(masterIp, groupName, true);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("error when RocketMQTopicUtil deleteSubscriptionGroup:", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"error when RocketMQTopicUtil deleteSubscriptionGroup,namesrvAddr:" + rocketInfo.getHost() + ",groupName:" + groupName});
        }
    }

    private static Set<String> getMasterAddrSet(MQAdminExt mqAdminExt, String clusterName) throws Exception {
        if (CLUSTERNAME_MASTERADDR_MAP.containsKey(clusterName)) {
            return CLUSTERNAME_MASTERADDR_MAP.get(clusterName);
        }
        Set masterSet = CommandUtil.fetchMasterAddrByClusterName((MQAdminExt)mqAdminExt, (String)clusterName);
        if (CollectionUtils.isEmpty((Collection)masterSet)) {
            LOGGER.error("error when RocketMQTopicUtil fetchMasterAddrByClusterName,clusterName:" + clusterName);
            throw new KDException(BosErrorCode.rocketmqException, new Object[]{"error when RocketMQTopicUtil fetchMasterAddrByClusterName,namesrvAddr:" + mqAdminExt.getNameServerAddressList() + ",clusterName:" + clusterName});
        }
        CLUSTERNAME_MASTERADDR_MAP.putIfAbsent(clusterName, masterSet);
        return masterSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultMQAdminExt getAdminExt(RocketInfo rocketInfo, RPCHook rpcHook) throws MQClientException {
        String key = rocketInfo.getClustername() + "_" + rocketInfo.getHost();
        DefaultMQAdminExt mqAdminExt = NAMESRV_ADMINEXT_MAP.get(key);
        if (mqAdminExt == null) {
            Object object = LOCKER;
            synchronized (object) {
                if (mqAdminExt == null) {
                    mqAdminExt = new DefaultMQAdminExt(rpcHook, 5000L);
                    mqAdminExt.setNamesrvAddr(rocketInfo.getHost());
                    mqAdminExt.setInstanceName(RocketmqFactory.getInstanceName((String)"demo"));
                    mqAdminExt.start();
                    NAMESRV_ADMINEXT_MAP.put(key, mqAdminExt);
                }
            }
        }
        return mqAdminExt;
    }
}

