/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.rocket;

import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.limiter.Limiter;
import kd.bos.limiter.constant.SceneCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.delay.DelayControlManager;
import kd.bos.mq.delay.MetaTime;
import kd.bos.mq.rocket.ProducerFactory;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.MessageSerde;
import kd.bos.mq.support.PublisherSupport;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.reporter.topology.TopologyTagInject;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.common.message.Message;

public class RocketPublisher
extends PublisherSupport {
    private static Log logger = LogFactory.getLog(RocketPublisher.class);
    private static final String ROCKET_TRACE_NAME = "RocketPublisher";
    private MQProducer producer;
    private String queueName;
    private String region;
    private String vhost;

    public RocketPublisher(MQProducer producer, String queueName, String region, String vhost) {
        super(false);
        this.producer = producer;
        this.queueName = queueName;
        this.region = region;
        this.vhost = vhost;
    }

    @Override
    protected void _beginTrans() {
    }

    @Override
    protected void _commitTrans() {
    }

    @Override
    protected void _rollbackTrans() {
    }

    @Override
    public void publish(byte[] message) {
        this.publish0(message);
    }

    @Override
    public void publish(String message) {
        this.publish0(message);
    }

    @Override
    public void publish(Object message) {
        this.publish0(message);
    }

    @Override
    public void publishInDbTranscation(Object message) {
        this.publishInDbTranscation(null, message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        this.publishDelayInDbTranscation(routKey, message, -1);
    }

    private void publishDelayInDbTranscation(String routKey, Object message, int seconds) {
        String writtenRouteKey = TX.getWrittenRouteKey();
        this.publish0(message, null, true, writtenRouteKey == null ? routKey : writtenRouteKey, seconds);
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        this.publishDelayInDbTranscation(null, message, seconds);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        this.publish0(message, null, false, null, seconds);
    }

    private void publish0(Object message) {
        this.publish0(message, null, false, null);
    }

    private void publish0(Object message, String consumeSynchronizeTag, boolean indbtrans, String routeKey) {
        this.publish0(message, consumeSynchronizeTag, indbtrans, routeKey, -1);
    }

    private void publish0(Object body, String consumeSynchronizeTag, boolean indbtrans, String routeKey, int seconds) {
        Limiter.checkAndRecord((String)SceneCode.MQ.getCode());
        if (!PublisherSupport.isCanPublishMessage(this.queueName)) {
            throw new KDException(BosErrorCode.rocketmqException, new Object[]{"The current node has been discarded due to grayscale completion,queue name is " + this.queueName});
        }
        try (TraceSpan span = Tracer.create((String)ROCKET_TRACE_NAME, (String)"publish0", (boolean)true);){
            span.addTag("queueName", this.queueName);
            DefaultMQProducer tempProducer = (DefaultMQProducer)this.producer;
            TopologyTagInject.setCompentTag((InnerSpan)span.getInnerSpan(), (String)tempProducer.getNamesrvAddr(), (String)"RocketMQ", (String)"mq");
            this.queueName = PublisherSupport.getStandardQueue(this.queueName);
            String publishQueueName = ConsumerSupport.getAcrossNodePublishQueueNameGray(this.queueName);
            String groupAndTopicName = ProducerFactory.getTopicAndGroupName(this.vhost, publishQueueName);
            kd.bos.mq.support.Message message = this.toMessage(body);
            message.setConsumeSynchronizeTag(consumeSynchronizeTag);
            if (indbtrans) {
                if (routeKey == null) {
                    throw new KDException(BosErrorCode.sQLConnection, new Object[]{"routKey  can  not be null"});
                }
                if (KdtxSupport.isDtxEnable()) {
                    this.startDTXAndRegistry(message, routeKey, this.region, groupAndTopicName);
                    return;
                }
                this.recordMqTrans(routeKey, message);
            }
            DelayControlManager.installDelayInfo(message, seconds);
            byte[] bytes = MessageSerde.get().encode(message);
            this.checkPayload(bytes, groupAndTopicName);
            Message rocketMessage = new Message(groupAndTopicName, "*", bytes);
            if (message.getStartDeliverTime() > 0L) {
                MetaTime maxMetaTime = DelayControlManager.selectMaxMetaTime(seconds);
                rocketMessage.setDelayTimeLevel(maxMetaTime.getLevel());
            }
            this.producer.send(rocketMessage);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"can't send,the reason is " + e.getMessage()});
        }
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        try {
            Message rocketMessage = new Message(this.queueName, "*", message);
            this.producer.send(rocketMessage);
        }
        catch (Exception e) {
            logger.error("$$publishConfirm error", (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.rocketmqException, new Object[]{"can't publish"});
        }
    }

    private kd.bos.mq.support.Message toMessage(Object body) {
        kd.bos.mq.support.Message message = new kd.bos.mq.support.Message();
        message.setBody(body);
        RequestContext rc = RequestContextCreator.createForMQ();
        message.setRequestContext(rc);
        message.setInnerId(RandomUtils.nextLong());
        return message;
    }

    @Override
    public void publish(Object message, String partitionKey) {
        throw new KDException(BosErrorCode.rocketmqException, new Object[]{"SimplePublisher can't publish message with partitionKey directly!"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        throw new KDException(BosErrorCode.rocketmqException, new Object[]{"SimplePublisher can't publishInDbTranscation with partitionKey directly !"});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        throw new KDException(BosErrorCode.rocketmqException, new Object[]{"SimplePublisher can't publishDelay message with partitionKey directly!"});
    }

    @Override
    public void close() {
        String producerCacheEnable = System.getProperty("mq.rocketmq.producer.cache.enable", "true");
        boolean flag = Boolean.parseBoolean(producerCacheEnable);
        if (!flag) {
            this.producer.shutdown();
        }
    }
}

