/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.AppUtils;

public class ConsumerSupport {
    private static Map<String, Boolean> isNeddDeployMap = new ConcurrentHashMap<String, Boolean>(2);
    private static Map<String, QueueDef> acrossNodeConsumeQueues = new ConcurrentHashMap<String, QueueDef>(2);
    private static Map<String, String> acrossNodeQueueRegion = new ConcurrentHashMap<String, String>(2);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mq", new DistributeCacheHAPolicy(true, false));
    private static final String PUBLISHFORACCROSSNODE_KEY = Instance.getClusterName() + "_NeedPublishForAccrossNode";
    private static final String OLDSTANDRANDCONSUMERISFINSH_KEY = Instance.getClusterName() + "_OldStandrandConsumerIsFinsh_";
    private static Map<String, String> existAcrossDestnationMap = new ConcurrentHashMap<String, String>(1);
    private static int waitSeconds = Integer.getInteger("mq.gray.across.publish.waitToChangeToNormalQueue", 3600);
    private static boolean isStartAsGrayNode = AppGroup.isCurrentGrayNode();

    public static boolean isNeedDeploy(String appid) {
        if (appid == null) {
            return true;
        }
        return isNeddDeployMap.computeIfAbsent(appid, k -> {
            String[] deployAppIds = Instance.getAppIds();
            boolean isCurrentDeployAlone = AppUtils.isDeployAloneApps((String[])deployAppIds);
            if (!Instance.isAppSplit() && !isCurrentDeployAlone) {
                return true;
            }
            if (deployAppIds == null) {
                return false;
            }
            String[] configAppIds = appid.split(",");
            for (String dappid : deployAppIds) {
                for (String configAppId : configAppIds) {
                    if (!configAppId.equals(dappid)) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public static void setAcrossNodeConsume(String region, String queueName, QueueDef def) {
        String appid = def.getAppid();
        if (isStartAsGrayNode && !ConsumerSupport.isNeedDeploy(appid)) {
            acrossNodeConsumeQueues.put(queueName, def);
            acrossNodeQueueRegion.put(queueName, region);
        }
    }

    public static String getAcrossNodePublishQueueNameGray(String queueName) {
        if (!AppGroup.isGrayUpgrade()) {
            return queueName;
        }
        QueueDef def = acrossNodeConsumeQueues.get(queueName);
        if (def == null) {
            return queueName;
        }
        String appid = def.getAppid();
        if (appid == null) {
            return queueName;
        }
        Set groups = AppGroup.getGrayingAppGroup((String)appid);
        if (groups.size() == 1) {
            String group = (String)groups.iterator().next();
            existAcrossDestnationMap.put(appid, group);
            String qdefName = QueueManager.getGroupQueueName(def.getName(), group);
            String grayName = QueueManager.getStandardQueueName(acrossNodeQueueRegion.get(queueName), qdefName);
            return grayName;
        }
        if (groups.size() == 0 && existAcrossDestnationMap.containsKey(appid)) {
            if (ConsumerSupport.needWaitPublishNormalForAccrossNode(appid)) {
                String group = existAcrossDestnationMap.get(appid);
                String qdefName = QueueManager.getGroupQueueName(def.getName(), group);
                String grayName = QueueManager.getStandardQueueName(acrossNodeQueueRegion.get(queueName), qdefName);
                return grayName;
            }
            existAcrossDestnationMap.remove(appid);
        }
        return queueName;
    }

    public static void setNeedWaitPublishForAccrossNode(String appId) {
        cache.put(PUBLISHFORACCROSSNODE_KEY, appId, appId, waitSeconds);
    }

    public static void setFreeWaitPublishForAccrossNode(String appId) {
        cache.remove(PUBLISHFORACCROSSNODE_KEY, appId);
        LockSupport.parkNanos(10000000000L);
    }

    private static boolean needWaitPublishNormalForAccrossNode(String appId) {
        String val = (String)cache.get(PUBLISHFORACCROSSNODE_KEY, appId);
        return val != null && val.length() > 0;
    }

    public static void setOldStandrandConsumerFinished(String appId, String group) {
        cache.put(OLDSTANDRANDCONSUMERISFINSH_KEY, appId + group, group, waitSeconds);
    }

    public static boolean isOldStandrandConsumerFinished(String appId, String group) {
        String val = (String)cache.get(OLDSTANDRANDCONSUMERISFINSH_KEY, appId + group);
        return val != null && val.length() > 0;
    }
}

