/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.MessageSerde;
import kd.bos.util.StringUtils;

public class KdtxSupport {
    private static final Log logger = LogFactory.getLog(KdtxSupport.class);
    private static final Map<Long, Object> ecInstance = new HashMap<Long, Object>();
    public static final String DTX_ENABLE = "mq.publish.kdtx.enable";
    public static final String DTX_MQ_CLEAN_NOW = "kdtx.mq.history.clean.sync";
    private static final String DTXFACTORY = "kd.bos.kdtx.sdk.session.DtxFactory";
    private static final String CREATE_SIMPLE_EC = "createSimpleEc";
    private static final String LOCAL_TX_DB_HELPER = "kd.bos.kdtx.common.localtx.LocalTxDbHelper";
    private static final String IS_RECEIVED = "isReceived";
    private static final String RECEIVED = "received";
    private static final String ALL_RECEIVED = "allReceived";
    private static final String SIMPLE_EC_SESSION = "kd.bos.kdtx.sdk.session.simpleec.SimpleECSession";
    private static final String REGISTER = "register";
    private static final String SET_ROUTE_KEY = "setDbRoute";
    private static final String FIELD_CACHE = "dBTxIdXidCache";
    private static final String COMPENSATE_SERVICE = "kd.bos.kdtx.server.compensate.CompensateService";
    private static final String SECOND_COMPENSATE = "mqSecondCompensate";
    private static final String IS_MANUAL = "isManual";
    private static final String COMPENSATE_SUCCESS = "compensateSuccess";
    private static final String HISTORY_CLEANER = "kd.bos.kdtx.server.tasks.HistoryCleaner";
    private static final String CLIAN_HISTORY = "cleanSimpleECHistory";
    private static final String RELIABLE_MQ_COMPENSATE_SERVICE = "kd.bos.kdtx.server.compensate.ReliableMqCompensateService";
    private static final String CREATE_MQ_MANUAL_TRANS = "createMqManualTrans";
    private static final String MQ_SCENES_CODE = "mq_publisher";
    private static final String SERIALIZER = "kd.bos.bos.inner.MqSerialiazer";
    private static final String CLOUD_ID = "bos";
    private static final String APP_ID = "bos";
    private static final String SERVICE_NAME = "mqPublishService";

    public static boolean isDtxEnable() {
        return Boolean.parseBoolean(System.getProperty(DTX_ENABLE, "false"));
    }

    public static Object createSimpleEc(String routeKey) {
        final Long id = TX.__getTXContext().id();
        return ecInstance.computeIfAbsent(id, k -> {
            try {
                Object ec = Class.forName(DTXFACTORY).getMethod(CREATE_SIMPLE_EC, String.class, String.class).invoke(null, MQ_SCENES_CODE, SERIALIZER);
                KdtxSupport.setRouteKey(ec, DBRoute.of((String)routeKey));
                TX.addCommitListener((CommitListener)new CommitListener(){

                    public void onCommitted() {
                        ecInstance.remove(id);
                    }

                    public void onRollbacked() {
                        ecInstance.remove(id);
                    }
                });
                return ec;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException("KdtxSupport createSimpleEc forName(kd.bos.kdtx.sdk.session.DtxFactory#createSimpleEc) fail:" + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                String msg = String.format("createSimpleEc fail:%s", e.getTargetException().getMessage());
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                throw new RuntimeException(msg, e.getTargetException());
            }
        });
    }

    public static void setRouteKey(Object target, DBRoute dbRouteKey) {
        try {
            Class.forName(SIMPLE_EC_SESSION).getMethod(SET_ROUTE_KEY, DBRoute.class).invoke(target, dbRouteKey);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport setRouteKey forName(kd.bos.kdtx.sdk.session.simpleec.SimpleECSession#setDbRoute) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("setRouteKey fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static String getXid() {
        if (TX.inTX()) {
            try {
                Map dBTxIdXidCache = (Map)Class.forName(SIMPLE_EC_SESSION).getDeclaredField(FIELD_CACHE).get(null);
                return (String)dBTxIdXidCache.get(TX.__getTXContext().id());
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("KdtxSupport getXid forName(kd.bos.kdtx.sdk.session.simpleec.SimpleECSession#dBTxIdXidCache) fail:" + e.getMessage(), e);
            }
        }
        throw new RuntimeException("No transaction exists(ensure call in TX)");
    }

    public static void register(Object target, Object param, List<String> businessParams) {
        try {
            Class.forName(SIMPLE_EC_SESSION).getMethod(REGISTER, String.class, String.class, String.class, Object.class, List.class).invoke(target, "bos", "bos", SERVICE_NAME, param, businessParams);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport register forName(kd.bos.kdtx.sdk.session.DtxFactory#register) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("register fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static boolean isReceived(DBRoute dbRoute, String xid, long seq) {
        try {
            return (Boolean)Class.forName(LOCAL_TX_DB_HELPER).getMethod(IS_RECEIVED, DBRoute.class, String.class, Long.TYPE).invoke(null, dbRoute, xid, seq);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport isReceived forName(kd.bos.kdtx.common.localtx.LocalTxDbHelper#isReceived) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("isReceived fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static void received(DBRoute dbRoute, String xid, long seq) {
        try {
            Class.forName(LOCAL_TX_DB_HELPER).getMethod(RECEIVED, DBRoute.class, String.class, Long.TYPE).invoke(null, dbRoute, xid, seq);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport received forName(kd.bos.kdtx.common.localtx.LocalTxDbHelper#received) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("received fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static boolean mqSecondCompensate(String xid, long seq) {
        try {
            return (Boolean)Class.forName(COMPENSATE_SERVICE).getMethod(SECOND_COMPENSATE, String.class, Long.TYPE).invoke(null, xid, seq);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport secondCompensate forName(kd.bos.kdtx.server.compensate.CompensateService#mqSecondCompensate) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("secondCompensate fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static boolean isManual(String xid, long seq) {
        try {
            return (Boolean)Class.forName(COMPENSATE_SERVICE).getMethod(IS_MANUAL, String.class, Long.TYPE).invoke(null, xid, seq);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport isManual forName(kd.bos.kdtx.server.compensate.CompensateService#isManual) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("isManual fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static void compensateSuccess(String xid, long seq) {
        try {
            Class.forName(COMPENSATE_SERVICE).getMethod(COMPENSATE_SUCCESS, String.class, Long.TYPE).invoke(null, xid, seq);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport compensateSuccess forName(kd.bos.kdtx.server.compensate.CompensateService#compensateSuccess) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("compensateSuccess fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }

    public static void recordLog(String xid, long seq, String errorMessage, boolean isError) {
        try {
            if (!StringUtils.isEmpty((String)errorMessage) && errorMessage.length() > 1000) {
                errorMessage = errorMessage.substring(0, 1000);
            }
            String sql = "INSERT INTO t_cbs_dtx_logs (fid, fxid, fbranch_id, faction_type, ftrigger_type, fresult, fremark, ftraceid, fcreate_time)VALUES (?,?,?,?,?,?,?,?,NOW())";
            long id = ID.genLongId();
            Object[] params = new Object[]{id, xid, seq, 14, 1, isError ? -1 : 1, errorMessage, RequestContext.get().getTraceId()};
            DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
        }
        catch (Exception e) {
            logger.warn("recordException fail", (Throwable)e);
        }
    }

    private static void cleanHistory(String xid) {
        try {
            Class.forName(HISTORY_CLEANER).getMethod(CLIAN_HISTORY, String.class).invoke(null, xid);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport cleanHistory forName(kd.bos.kdtx.server.tasks.HistoryCleaner#cleanSimpleECHistory) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            KdtxSupport.recordLog(xid, 0L, "\"recordException fail" + e.getTargetException().getMessage(), true);
        }
    }

    private static void allReceived(DBRoute dbRoute, String xid) {
        try {
            Class.forName(LOCAL_TX_DB_HELPER).getMethod(ALL_RECEIVED, DBRoute.class, String.class).invoke(null, dbRoute, xid);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport allReceived forName(kd.bos.kdtx.common.localtx.LocalTxDbHelper#allReceived) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            KdtxSupport.recordLog(xid, 0L, "allReceived fail" + e.getTargetException().getMessage(), true);
        }
    }

    public static void endConsumer(DBRoute dbRoute, String xid) {
        if (dbRoute != null) {
            KdtxSupport.allReceived(dbRoute, xid);
        }
        if (Boolean.parseBoolean(System.getProperty(DTX_MQ_CLEAN_NOW, "true"))) {
            KdtxSupport.cleanHistory(xid);
        }
    }

    public static void message2ManualCompensate(Message message, String region, String realQueueName) {
        message.setKdtxId(message.getTranscationTag());
        message.setSeq(0L);
        message.setRealQueueName(realQueueName);
        message.setRegion(region);
        byte[] bytes = MessageSerde.get().encode(message);
        try {
            Class.forName(RELIABLE_MQ_COMPENSATE_SERVICE).getMethod(CREATE_MQ_MANUAL_TRANS, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, byte[].class).invoke(null, message.getRouteKey(), message.getKdtxId(), "bos", "bos", SERVICE_NAME, realQueueName, MQ_SCENES_CODE, SERIALIZER, bytes);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException("KdtxSupport origin2Manual forName(kd.bos.kdtx.server.compensate.ReliableMqCompensateService#createMqManualTrans) fail:" + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            String msg = String.format("origin2Manual fail:%s", e.getTargetException().getMessage());
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(msg, e.getTargetException());
        }
    }
}

