/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.KdtxSupport;
import kd.bos.mq.support.Message;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.TranscationSupport;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;

public abstract class PublisherSupport
implements MessagePublisher {
    private static Log logger = LogFactory.getLog(PublisherSupport.class);
    private static Map<String, Boolean> messageSendController = new ConcurrentHashMap<String, Boolean>(8);
    private static Map<String, Boolean> messageChangeController = new ConcurrentHashMap<String, Boolean>(8);
    public static final String MQ_MESSAGE_PAYLOAD_KEY = "mq.message.payload";
    public static int MQ_MESSAGE_PAYLOAD_VALUE = 0x1900000;
    private static Set<Long> dbTxIds;

    protected PublisherSupport(boolean isTransactional) {
    }

    protected abstract void _beginTrans();

    protected abstract void _commitTrans();

    protected abstract void _rollbackTrans();

    @Override
    public void publish(byte[] bytes) {
    }

    @Override
    public void $$publishConfirm(byte[] message) {
    }

    protected static boolean isCanPublishMessage(String queueNameWithAppGroup) {
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName("", queueNameWithAppGroup);
        String appId = queueDef.getAppid();
        if (appId == null) {
            return true;
        }
        return messageSendController.getOrDefault(appId, Boolean.TRUE);
    }

    protected static boolean isChangePublishMessage(String appId) {
        return messageChangeController.getOrDefault(appId, Boolean.FALSE);
    }

    protected static String getStandardQueue(String queueNameWithAppGroup) {
        QueueDef queueDef = QueueManager.getQueueDefWithRealQueueName("", queueNameWithAppGroup);
        if (queueDef.getAppid() == null) {
            return queueNameWithAppGroup;
        }
        if (PublisherSupport.isChangePublishMessage(queueDef.getAppid())) {
            return QueueManager.getQueueNameMap().get(queueNameWithAppGroup);
        }
        return queueNameWithAppGroup;
    }

    protected final void recordMqTrans(String routeKey, Message message) {
        final String xid = String.valueOf(IDService.get().genLongId());
        TranscationSupport.instance().insert(routeKey, xid);
        message.setTranscationTag(xid);
        message.setRouteKey(routeKey);
        message.setRetryTimes(TranscationSupport.longTxDelayStrategyEnable() ? 0 : -1);
        final long dbTxId = TX.__getTXContext().id();
        if (dbTxIds.add(dbTxId)) {
            TX.addCommitListener((CommitListener)new CommitListener(){

                public void onCommitted() {
                    dbTxIds.remove(dbTxId);
                }

                public void onRollbacked() {
                    try {
                        TranscationSupport.instance().xidRollBack(xid);
                    }
                    finally {
                        dbTxIds.remove(dbTxId);
                    }
                }
            });
        }
    }

    protected final void startDTXAndRegistry(Message message, String routeKey, String region, String realQueueName) {
        message.setRealQueueName(realQueueName);
        message.setRegion(region);
        message.setRouteKey(routeKey);
        Object ec = KdtxSupport.createSimpleEc(routeKey);
        ArrayList<String> biz = new ArrayList<String>();
        biz.add(realQueueName);
        KdtxSupport.register(ec, message, biz);
    }

    protected final void checkPayload(byte[] bytes, String publishQueueName) {
        int limit = MQ_MESSAGE_PAYLOAD_VALUE;
        if (bytes.length > limit) {
            if (Boolean.parseBoolean(System.getProperty("mq.message.overload.throw", "true"))) {
                throw new KDException(BosErrorCode.mqException, new Object[]{String.format("message body overload,limit %s bytes,actual %s bytes  ,queue %s", limit, bytes.length, publishQueueName)});
            }
            logger.error("publish0 overload", (Throwable)new KDException(BosErrorCode.mqException, new Object[]{String.format("message body overload,limit %s bytes,actual %s bytes ,queue %s", limit, bytes.length, publishQueueName)}));
        }
    }

    public static void $$disablePublishMessage(String appid) {
        messageSendController.putIfAbsent(appid, Boolean.FALSE);
    }

    public static void $$changePublishMessage(String appid) {
        messageChangeController.putIfAbsent(appid, Boolean.TRUE);
    }

    @Override
    public void close() {
    }

    static {
        MQ_MESSAGE_PAYLOAD_VALUE = ConfigurationUtil.getInteger((String)MQ_MESSAGE_PAYLOAD_KEY, (Integer)MQ_MESSAGE_PAYLOAD_VALUE);
        ConfigurationUtil.observeChange((String)MQ_MESSAGE_PAYLOAD_KEY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                MQ_MESSAGE_PAYLOAD_VALUE = Integer.getInteger(PublisherSupport.MQ_MESSAGE_PAYLOAD_KEY);
            }
        });
        dbTxIds = new HashSet<Long>();
    }
}

