/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.extension.ExtensionFactory;
import kd.bos.instance.AppGroup;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConfigKeys;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.failover.FailoverConfig;
import kd.bos.mq.failover.FailoverMoveTaskFactory;
import kd.bos.mq.failover.FailoverQueueManager;
import kd.bos.mq.pigeon.PigeonConsumer;
import kd.bos.mq.pigeon.PigeonConsumerManager;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.support.ConfigForInitConsumer;
import kd.bos.mq.support.Consumer;
import kd.bos.mq.support.ConsumerSupport;
import kd.bos.mq.support.MessageConsumerWrapper;
import kd.bos.mq.support.NoneInitDelayConsumer;
import kd.bos.mq.support.QueueDeclare;
import kd.bos.mq.support.partition.BroadcastConsumer;
import kd.bos.mq.support.partition.BroadcastConsumerWrapper;
import kd.bos.mq.support.partition.QueueMetaManager;
import kd.bos.mq.support.partition.ZKQueueManager;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class QueueManager {
    public static final int DEFAULT_CONSUMER_CONCURRENCY = 1;
    public static final int DEFAULT_QUEUE_MAXlENGTH = 1000000;
    private static final Log logger = LogFactory.getLog(QueueManager.class);
    private static ConcurrentHashMap<String, QueueDef> queueDefs = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> queueGroup = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> queueDeclared = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Boolean> failoverQueueDeclared = new ConcurrentHashMap();
    private static String queueTag = System.getProperty("mq.debug.queue.tag");
    private static Map<String, Object> consumers = new ConcurrentHashMap<String, Object>();
    private static Map<String, Consumer> deLayConsumers = new ConcurrentHashMap<String, Consumer>();
    private static Map<String, NoneInitDelayConsumer> noneInitDeLayConsumers = new ConcurrentHashMap<String, NoneInitDelayConsumer>();
    private static Map<String, String> mqTypeMap = new ConcurrentHashMap<String, String>();
    private static Map<String, ThreadPool> poolMap = new ConcurrentHashMap<String, ThreadPool>();
    private static Map<String, String> queueNameMap = new ConcurrentHashMap<String, String>(128);
    private static Map<String, String> queueAppMap = new ConcurrentHashMap<String, String>(128);
    private static Set<String> log = new HashSet<String>();

    public static String getRealQueueName(String region, String queueDefName) {
        String mainGroupName = QueueManager.getStandardQueueName(region, queueDefName);
        String group = queueGroup.get(region + queueDefName);
        if (group != null) {
            queueDefName = QueueManager.getGroupQueueName(queueDefName, group);
            String grayName = QueueManager.getStandardQueueName(region, queueDefName);
            queueNameMap.putIfAbsent(grayName, mainGroupName);
            return grayName;
        }
        return mainGroupName;
    }

    public static String getGroupQueueName(String queueDefName, String appGroup) {
        return queueDefName + "." + appGroup;
    }

    protected static String getStandardQueueName(String region, String queueDefName) {
        return region + "." + (queueTag == null ? queueDefName : queueDefName + "." + queueTag);
    }

    public static String getRealQueueNameWithAppid(String region, String queueDefName, String appid) {
        return appid + "." + QueueManager.getRealQueueName(region, queueDefName);
    }

    public static void _$defineQueue(String region, QueueDef queueDef, String appid) {
        String queueName = QueueManager.getRealQueueNameWithAppid(region, queueDef.getName(), appid);
        queueDefs.putIfAbsent(queueName, queueDef);
    }

    public static void _$defineQueue(String queueName, QueueDef queueDef) {
        queueDefs.putIfAbsent(queueName, queueDef);
    }

    public static boolean queueHasDefine(String queueName) {
        return queueDefs.containsKey(queueName);
    }

    public static void add(String region, QueueDef queueDef) {
        QueueManager.add(region, queueDef, true);
    }

    public static void add(String region, QueueDef queueDef, boolean initConsumer) {
        queueGroup.computeIfAbsent(region + queueDef.getName(), k -> {
            String appid = queueDef.getAppid();
            if (appid == null || !AppGroup.isCurrentGrayNode()) {
                return null;
            }
            return AppGroup.getCurrentGrayAppGroup((String)queueDef.getAppid());
        });
        String queueName = QueueManager.getRealQueueName(region, queueDef.getName());
        queueDefs.put(queueName, queueDef);
        if (initConsumer) {
            QueueManager.initQueueConsumers(region, queueName, queueDef);
        }
    }

    public static void addWithAppidTags(String region, QueueDef queueDef) {
        String[] appids = Instance.getAppIds();
        if (appids == null) {
            throw new KDException(BosErrorCode.configNotFound, new Object[]{String.format(Resources.getString((String)"\u6ca1\u6709\u914d\u7f6eappIds,%s", (String)"QueueManager_0", (String)"bos-mq", (Object[])new Object[0]), System.getProperty("appName"))});
        }
        for (String appid : appids) {
            QueueDef newQueueDef = QueueManager.cloneQueueDef(queueDef);
            if (StringUtils.isEmpty((String)newQueueDef.getAppid())) {
                newQueueDef.setAppid(appid);
            }
            String _queueName = QueueManager.getRealQueueNameWithAppid(region, newQueueDef.getName(), appid);
            queueDefs.put(_queueName, newQueueDef);
            QueueManager.initQueueConsumers(region, _queueName, newQueueDef);
        }
    }

    private static QueueDef cloneQueueDef(QueueDef queueDef) {
        QueueDef newQueueDef = new QueueDef();
        newQueueDef.setName(queueDef.getName());
        newQueueDef.setTransactional(queueDef.isTransactional());
        newQueueDef.setDuration(queueDef.isDuration());
        newQueueDef.setMaxQueueLength(queueDef.getMaxQueueLength());
        newQueueDef.setAppid(queueDef.getAppid());
        newQueueDef.setLazyInit(queueDef.isLazyInit());
        newQueueDef.setSequential(queueDef.isSequential());
        newQueueDef.setConsumers(queueDef.getConsumers());
        newQueueDef.setPartition(queueDef.isPartition());
        return newQueueDef;
    }

    public static QueueDef getQueueDefWithQueueDefNameAndAppid(String region, String queueDefName, String appid) {
        return queueDefs.get(QueueManager.getRealQueueNameWithAppid(region, queueDefName, appid));
    }

    public static QueueDef get(String region, String queueDefName) {
        return queueDefs.get(QueueManager.getRealQueueName(region, queueDefName));
    }

    public static QueueDef getQueueDefWithRealQueueName(String region, String queueRealName) {
        return queueDefs.get(queueRealName);
    }

    public static void declareIfNeed(Channel channel, String region, String queueRealName, int maxQueueLength) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (maxQueueLength <= 0 || maxQueueLength > 1000000) {
            maxQueueLength = 1000000;
        }
        args.put("x-max-length", maxQueueLength);
        if (Boolean.TRUE.equals(queueDeclared.get(queueRealName))) {
            return;
        }
        QueueDef def = queueDefs.get(queueRealName);
        QueueDeclare queueDeclarer = QueueDeclare.get(QueueManager.getMQType(region));
        queueDeclarer.queueDeclare(region, queueRealName, def.isDuration(), args);
        queueDeclared.putIfAbsent(queueRealName, true);
        if (FailoverConfig.MQ_FAILOVER_ENABLE) {
            failoverQueueDeclared.putIfAbsent(queueRealName, true);
        }
    }

    public static void broadcastConsumerIfNeed(String region, QueueDef originDef, String queueRealName, String appId) {
        String broadType = System.getProperty("mq.queue.consumer.broadcast.type", "http");
        String consumerMetaStoreType = QueueMetaManager.getConsumerMetaStoreType();
        if (consumerMetaStoreType.equals("zookeeper") && ZKQueueManager.existMqConsumer(queueRealName)) {
            broadType = "mq";
        }
        if (BroadcastConsumerWrapper.validBroadcast(queueRealName) && ZKQueueManager.existQueueMeta(region, originDef.getName(), appId)) {
            if (log.add(queueRealName)) {
                logger.info("queue:[" + queueRealName + "] all node consumer started");
            }
            return;
        }
        if (BroadcastConsumerWrapper.needBroadcastSync(queueRealName)) {
            broadType = "http";
        }
        BroadcastConsumer broadcastConsumer = (BroadcastConsumer)ExtensionFactory.getExtensionFacotry(BroadcastConsumer.class).getExtension(broadType);
        broadcastConsumer.broadRegisterConsumer(region, originDef.getName(), queueRealName, appId);
    }

    private static void initQueueConsumers(String region, String queueName, QueueDef queueDef) {
        if (!ConfigForInitConsumer.isConsumerRegionEnable(region)) {
            return;
        }
        List<ConsumerDef> consumers = queueDef.getConsumers();
        if (consumers == null || consumers.isEmpty()) {
            logger.error("mq.usage config consumers is empty for " + region + "/" + queueDef.getName());
            return;
        }
        ConsumerDef consumer = consumers.get(0);
        if (ConfigForInitConsumer.isNotInitConsumer()) {
            return;
        }
        if (ConfigForInitConsumer.needWaitingInitConsumer()) {
            ThreadPool pool = poolMap.computeIfAbsent(QueueManager.class.getName(), k -> ThreadPools.newFixedThreadPool((String)"Mq-InitConsumer", (int)1));
            pool.execute(() -> {
                while (ConfigForInitConsumer.needWaitingInitConsumer()) {
                    LockSupport.parkNanos(1000000000L);
                }
                try {
                    QueueManager.initConsumer(region, queueName, queueDef, consumer);
                }
                catch (Exception e) {
                    logger.warn("Not deploy mq for  queue " + region + "/" + queueName + " ," + e.getMessage(), (Throwable)e);
                }
            });
        } else {
            QueueManager.initConsumer(region, queueName, queueDef, consumer);
        }
        for (int i = 1; i < consumers.size(); ++i) {
            logger.warn("mq.usage consumer " + consumers.get(i).getClassName() + " ignored. only one cunsumer allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef) {
        String clazz = consumerDef.getClassName();
        if (consumers.containsKey(queueName)) {
            return;
        }
        Class<QueueManager> clazz2 = QueueManager.class;
        synchronized (QueueManager.class) {
            if (consumers.containsKey(queueName)) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            try {
                String appId = queueDef.getAppid();
                if (appId != null) {
                    queueAppMap.putIfAbsent(queueName, appId);
                }
                String mqType = QueueManager.getMQType(region);
                MessageConsumer mc = (MessageConsumer)Class.forName(clazz).newInstance();
                MessageConsumerWrapper mcWrapper = new MessageConsumerWrapper(mc);
                if (Instance.isLightWeightDeploy() || "fakemq".equals(mqType)) {
                    Constructor<?> constructor = Class.forName("kd.bos.fake.mq.RabbitConsumerFake").getConstructor(String.class, String.class, Boolean.TYPE, Integer.TYPE, MessageConsumer.class, Integer.TYPE);
                    Object consumer = constructor.newInstance(region, queueName, consumerDef.isAutoAck(), QueueManager.getConcurrency(consumerDef), mcWrapper, queueDef.getMaxQueueLength());
                    consumers.put(queueName, consumer);
                } else {
                    QueueDeclare queueDeclarer = QueueDeclare.get(mqType);
                    Consumer consumer = queueDeclarer.getConsumer(region, queueName, queueDef, consumerDef, mcWrapper);
                    consumers.put(queueName, consumer);
                    if (queueDef.isLazyInit() || queueDef.isSequential()) {
                        String realQueueName = QueueManager.getRealQueueName(region, queueDef.getName());
                        deLayConsumers.put(realQueueName, consumer);
                        NoneInitDelayConsumer noneInitDeLayConsumer = noneInitDeLayConsumers.get(realQueueName);
                        if (noneInitDeLayConsumer != null && noneInitDeLayConsumer.isStarted()) {
                            consumer.start();
                            if (FailoverConfig.MQ_FAILOVER_ENABLE) {
                                FailoverQueueManager.registerQueueName(region, queueName);
                                FailoverMoveTaskFactory.registerTask(region, queueName);
                            }
                        }
                    } else {
                        consumer.start();
                        if (FailoverConfig.MQ_FAILOVER_ENABLE) {
                            FailoverQueueManager.registerQueueName(region, queueName);
                            FailoverMoveTaskFactory.registerTask(region, queueName);
                        }
                    }
                }
                try {
                    if (QueueMetaManager.getConsumerMetaStoreType().equals("zookeeper")) {
                        ZKQueueManager.registDynamicMqConsumer(queueDef.isPartition(), queueName);
                    }
                }
                catch (Exception e) {
                    logger.warn("registryMqConsumer fail for queue {}", (Object)e, (Object)queueName);
                }
            }
            catch (ClassNotFoundException | Error | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new KDException(e, BosErrorCode.mqException, new Object[]{"Can't init consumer by class " + clazz});
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static Map<String, Object> getConsumers() {
        return Collections.unmodifiableMap(consumers);
    }

    public static Map<String, String> getQueueNameMap() {
        return Collections.unmodifiableMap(queueNameMap);
    }

    public static Map<String, QueueDef> getAllQueueDefs() {
        return Collections.unmodifiableMap(queueDefs);
    }

    public static Map<String, String> getQueueAppMap() {
        return Collections.unmodifiableMap(queueAppMap);
    }

    public static Consumer getLazyInitConsumer(String region, String queueName) {
        String realQueueName = QueueManager.getRealQueueName(region, queueName);
        if (ConfigForInitConsumer.isConsumerEnable()) {
            return deLayConsumers.get(realQueueName);
        }
        return noneInitDeLayConsumers.computeIfAbsent(realQueueName, k -> new NoneInitDelayConsumer(realQueueName));
    }

    public static int getConcurrency(ConsumerDef consumerDef) {
        int concurrency = consumerDef.getConcurrency();
        if (concurrency == -1) {
            concurrency = ConfigurationUtil.getInteger((String)"mq.consumer.concurrency", (Integer)1);
        }
        return concurrency;
    }

    public static void resetConsumer(String k) {
        QueueManager.updateConsumer(k, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateConsumer(String k, Integer concurrency) {
        block10: {
            Object o = consumers.get(k);
            if (o instanceof Consumer) {
                Consumer consumer = (Consumer)o;
                int oldConcurrency = consumer.getConcurrency();
                if (concurrency > 0) {
                    consumer.setConcurrency(concurrency);
                }
                if (!consumer.isStarted()) {
                    return;
                }
                try {
                    consumer.$$stop();
                    if (o instanceof RabbitConsumer) {
                        RabbitConsumer rc = (RabbitConsumer)consumer;
                        rc.setChannel(ChannelFactory.getChannel(rc.getRegion()));
                        break block10;
                    }
                    if (!(o instanceof PigeonConsumer)) break block10;
                    int diff = concurrency - oldConcurrency;
                    PigeonConsumer pigeonConsumer = (PigeonConsumer)o;
                    AtomicInteger concurrencyAtomicInteger = PigeonConsumerManager.getConcurrency(pigeonConsumer.getQueueName());
                    if (concurrencyAtomicInteger == null) break block10;
                    AtomicInteger atomicInteger = concurrencyAtomicInteger;
                    synchronized (atomicInteger) {
                        concurrencyAtomicInteger.addAndGet(diff);
                        PigeonConsumerManager.getWaiting(pigeonConsumer.getQueueName()).addAndGet(diff);
                    }
                }
                finally {
                    consumer.start();
                }
            }
        }
    }

    public static void registryConsumerByAppId(String region, String originQueueName, String appId) {
        if (!ConsumerSupport.isNeedDeploy(appId)) {
            return;
        }
        String originRealName = QueueManager.getRealQueueName(region, originQueueName);
        QueueDef queueDef = queueDefs.get(originRealName);
        if (queueDef == null) {
            throw new KDException(BosErrorCode.mqException, new Object[]{"dynamicRegistryConsumer fail: queue " + originRealName + " has not define or do not support dynamic"});
        }
        String queueNameWithAppId = StringUtils.isNotEmpty((String)appId) ? originQueueName + "." + appId : originQueueName;
        String realQueueName = QueueManager.getRealQueueName(region, queueNameWithAppId);
        Object o = consumers.get(realQueueName);
        if (o instanceof Consumer && ((Consumer)o).isStarted()) {
            if (QueueMetaManager.getConsumerMetaStoreType().equals("zookeeper") && (ZKQueueManager.registryConsumerFailCache.contains(realQueueName) || !ZKQueueManager.existMqConsumer(realQueueName, true))) {
                ZKQueueManager.registDynamicMqConsumer(true, realQueueName);
            }
        } else {
            QueueDef queueDefNew = QueueManager.redefineQueueDef(queueDef, appId, queueNameWithAppId);
            QueueManager.add(region, queueDefNew);
        }
    }

    public static QueueDef redefineQueueDef(QueueDef source, String appId, String queueNameWithAppId) {
        QueueDef queueDefNew;
        try {
            String str = JSONUtils.toString((Object)source, (boolean)false);
            queueDefNew = (QueueDef)JSONUtils.cast((String)str, QueueDef.class);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"copy queueDef fail" + e.getMessage()});
        }
        queueDefNew.setAppid(appId);
        queueDefNew.setName(queueNameWithAppId);
        queueDefNew.setPartition(true);
        return queueDefNew;
    }

    public static void putConsumerForGray(String queueName, Consumer consumer) {
        consumers.putIfAbsent(queueName, consumer);
    }

    public static void putQueueDefForGray(String queueName, QueueDef queueDef) {
        queueDefs.putIfAbsent(queueName, queueDef);
    }

    public static String getMQType(String region) {
        String type = mqTypeMap.get(region);
        if (type != null) {
            return type;
        }
        String serverKey = "mq.server." + region;
        String server = System.getProperty(serverKey);
        try {
            if (server != null) {
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "type can't be empty.");
            } else {
                type = mqTypeMap.get("mq.server");
                if (type != null) {
                    return type;
                }
                server = System.getProperty("mq.server");
                if (server == null) {
                    throw new KDException(BosErrorCode.mqServerConfiguration, new Object[]{"mq server not config for " + server});
                }
                Properties prop = new Properties();
                StringReader reader = new StringReader(server);
                prop.load(reader);
                type = Objects.requireNonNull(prop.getProperty("type"), "QueueManager.getMQType() type can't be empty.");
                region = "mq.server";
            }
        }
        catch (IOException e) {
            logger.error("get mq type exception", (Throwable)e);
        }
        if (Arrays.asList(ConfigKeys.JMS_PROVIDERS).contains(type)) {
            type = "jms";
        }
        mqTypeMap.put(region, type);
        return type != null ? type.trim() : null;
    }

    public static Map<String, String> getMqTypeMap() {
        return Collections.unmodifiableMap(mqTypeMap);
    }
}

