/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.dtx.XidInfo;
import kd.bos.dtx.dao.DTXDao;
import kd.bos.dtx.dao.SyncDTXDao;
import kd.bos.dtx.dao.SyncRetryDTXDao;
import kd.bos.dtx.model.RetryInfo;
import kd.bos.util.StringUtils;

public class TranscationSupport {
    private DTXDao<XidInfo> dao;
    private DTXDao<RetryInfo> consumedDao = new SyncRetryDTXDao();
    private static final String OPE_CODE = "MQ";
    private DistributeSessionlessCache cache;
    private Map<String, Boolean> initedRouteMap = new ConcurrentHashMap<String, Boolean>(8);
    private static final String PREKEY = "rollback_mq_xid_";
    private static final String MQPREKEY = "mq_tx_id";
    private static final String MQ_LONG_TX_DELAY_QUEUE_STRATEGY_ENABLE = "mq.tx.delay.queue.strategy.enable";
    private static final String MQ_LONG_TX_DELAY_QUEUE_STRATEGY_ENABLE_TENANT = "mq.tx.delay.queue.strategy.enable.tenant";
    public static final int MAX_RETRY_TIMES = 14;
    public static final int CONSUMER_DELAY_MIN_LEVEL = 3;
    public static final int NOT_FIRE_CONSUMER_LATER_DELAY_LEVEL = -1;
    private static boolean FORCE_FIRE_LONG_TX_STRATEGY = false;

    public static TranscationSupport instance() {
        return TranscationSupportHolder.support;
    }

    private TranscationSupport() {
        this.dao = new SyncDTXDao();
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mqRetryCount", new DistributeCacheHAPolicy(true, true));
    }

    public static boolean longTxDelayStrategyEnable() {
        boolean enableDelayStrategy = Boolean.parseBoolean(System.getProperty(MQ_LONG_TX_DELAY_QUEUE_STRATEGY_ENABLE, "true"));
        boolean tenantActive = false;
        RequestContext requestContext = RequestContext.get();
        String tenantId = null;
        if (requestContext != null) {
            tenantId = RequestContext.get().getTenantId();
        }
        String tenantIdConfig = System.getProperty(MQ_LONG_TX_DELAY_QUEUE_STRATEGY_ENABLE_TENANT, "");
        if (StringUtils.isEmpty((String)tenantId) || StringUtils.isEmpty((String)tenantIdConfig)) {
            tenantActive = true;
        } else {
            String[] tenantIds = tenantIdConfig.split(",");
            if (tenantIds.length > 0) {
                for (String t : tenantIds) {
                    if (!tenantId.equals(t)) continue;
                    tenantActive = true;
                    break;
                }
            }
        }
        boolean active = enableDelayStrategy && tenantActive;
        return FORCE_FIRE_LONG_TX_STRATEGY || active;
    }

    public static void fireTxDelayStrategy() {
        FORCE_FIRE_LONG_TX_STRATEGY = true;
    }

    public static void crushOutTxDelayStrategy() {
        FORCE_FIRE_LONG_TX_STRATEGY = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeed(String routeKey, DTXDao<?> dao) {
        String mapKey = RequestContext.getOrCreate().getAccountId() + routeKey + dao.getClass().getName();
        if (this.initedRouteMap.containsKey(mapKey)) {
            return;
        }
        Map<String, Boolean> map = this.initedRouteMap;
        synchronized (map) {
            boolean existTable = DB.exitsTable((DBRoute)DBRoute.of((String)routeKey), (String)dao.getTableName());
            if (!existTable) {
                try {
                    TX.beginNew();
                    dao.createTable(routeKey);
                }
                finally {
                    TX.end();
                }
            }
            this.initedRouteMap.put(mapKey, true);
        }
    }

    public void insert(String routeKey, String xid) {
        this.initIfNeed(routeKey, this.dao);
        this.dao.insert(new XidInfo(xid, OPE_CODE), routeKey);
    }

    public boolean existXid(String routeKey, String xid) {
        this.initIfNeed(routeKey, this.dao);
        return this.dao.get((XidInfo)((Object)xid), routeKey) != null;
    }

    public void deleteXid(String routeKey, String xid) {
        this.initIfNeed(routeKey, this.dao);
        this.dao.delete(xid, routeKey);
    }

    public int tryTimes(String xid) {
        return (int)this.cache.inc(MQPREKEY + xid, 36000);
    }

    public void delTryTimes(String xid) {
        this.cache.remove(MQPREKEY + xid);
    }

    public boolean existConsumedId(String consumeRouteKey, String cid) {
        this.initIfNeed(consumeRouteKey, this.consumedDao);
        return this.consumedDao.get((RetryInfo)((Object)cid), consumeRouteKey) != null;
    }

    public void insertConsumed(String consumeRouteKey, String cid) {
        this.initIfNeed(consumeRouteKey, this.consumedDao);
        RetryInfo ri = new RetryInfo(cid, cid);
        ri.setOpCode(OPE_CODE);
        this.consumedDao.insert(ri, consumeRouteKey);
    }

    public void xidRollBack(String xid) {
        this.cache.put(PREKEY + xid, (Object)xid, 604800);
    }

    public boolean isRollBack(String xid) {
        return this.cache.contains(PREKEY + xid);
    }

    private static class TranscationSupportHolder {
        private static TranscationSupport support = new TranscationSupport();

        private TranscationSupportHolder() {
        }
    }
}

